/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.exception.RestException:20181225110811
 *
 * RestException.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.exception;


import cc.zuv.web.support.IWebERRCode;

import java.io.Serializable;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
public class RestException extends RuntimeException implements Serializable
{

    //-----------------------------------------------------------------------------------------

    private static final long serialVersionUID = 8711699682133946675L;

    //-----------------------------------------------------------------------------------------

    private IWebERRCode errcode;
    private String      message;
    private Object[]    params;

    //-----------------------------------------------------------------------------------------

    public RestException(IWebERRCode errcode)
    {
        this.errcode = errcode;
    }

    public RestException(IWebERRCode errcode, String message, Object... params)
    {
        this.errcode = errcode;
        this.message = message;
        this.params = params;
    }

    //-----------------------------------------------------------------------------------------

    public IWebERRCode getErrcode()
    {
        return errcode;
    }

    public void setErrcode(IWebERRCode errcode)
    {
        this.errcode = errcode;
    }

    @Override
    public String getMessage()
    {
        return message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    public Object[] getParams()
    {
        return params;
    }

    public void setParams(Object[] params)
    {
        this.params = params;
    }

    //-----------------------------------------------------------------------------------------

}
