/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.payload.RestResult:20181225110811
 *
 * RestResult.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.payload;

import cc.zuv.IERRCode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.http.HttpStatus;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RestResult<T> implements IRestResult<T>, IERRCode
{

    //-----------------------------------------------------------------------------------------

    //
    /*
    {
        "timestamp": 1524925080672,
        "status": 500,
        "error": "Internal Server Error",
        "exception": "org.springframework.dao.DataIntegrityViolationException",
        "message": "could not execute statement; SQL [n/a]; constraint [null]; nested exception is org.hibernate.exception.ConstraintViolationException: could not execute statement",
        "path": "/api/v1/user/create"
    }
    */

    //-----------------------------------------------------------------------------------------

    @ApiModelProperty(value = "HTTP状态", position = 0)
    private Integer status;
    @ApiModelProperty(value = "执行路径", position = 1)
    private String  epoint;
    @ApiModelProperty(value = "执行方式", position = 2)
    private String  method;
    @ApiModelProperty(value = "执行时戳", position = 3)
    private long    tstamp;

    @ApiModelProperty(value = "错误编码", position = 10)
    private Integer errcode;
    @ApiModelProperty(value = "提示信息", position = 11)
    private String  message;
    @ApiModelProperty(value = "数据承载", position = 99)
    private T       payload;

    //-----------------------------------------------------------------------------------------

    public RestResult()
    {
        this.status     = HttpStatus.OK.value();
        this.tstamp     = System.currentTimeMillis();
        this.errcode    = ERRCODE_SUCCESS;
        this.message    = MESSAGE_SUCCESS;
    }

    public RestResult(T payload)
    {
        this.status     = HttpStatus.OK.value();
        this.tstamp     = System.currentTimeMillis();
        this.errcode    = ERRCODE_SUCCESS;
        this.message    = MESSAGE_SUCCESS;
        this.payload    = payload;
    }

    public RestResult(int errcode, String message)
    {
        this.status     = HttpStatus.OK.value();
        this.tstamp     = System.currentTimeMillis();
        this.errcode    = errcode;
        this.message    = message;
    }

    public RestResult(int errcode, String message, T payload)
    {
        this.status     = HttpStatus.OK.value();
        this.tstamp     = System.currentTimeMillis();
        this.errcode    = errcode;
        this.message    = message;
        this.payload    = payload;
    }

    public RestResult(HttpStatus status, int errcode, String message, T payload)
    {
        this.status     = status.value();
        this.tstamp     = System.currentTimeMillis();
        this.errcode    = errcode;
        this.message    = message;
        this.payload    = payload;
    }

    public RestResult(HttpStatus status, String epoint, String method, int errcode, String message)
    {
        this.status     = status.value();
        this.epoint     = epoint;
        this.method     = method;
        this.tstamp     = System.currentTimeMillis();
        this.errcode    = errcode;
        this.message    = message;
    }

    //-----------------------------------------------------------------------------------------

    public Integer getStatus()
    {
        return status;
    }

    public void setStatus(Integer status)
    {
        this.status = status;
    }

    public String getEpoint()
    {
        return epoint;
    }

    public void setEpoint(String epoint)
    {
        this.epoint = epoint;
    }

    public String getMethod()
    {
        return method;
    }

    public void setMethod(String method)
    {
        this.method = method;
    }

    public Long getTstamp()
    {
        return tstamp;
    }

    public void setTstamp(Long tstamp)
    {
        this.tstamp = tstamp;
    }

    @Override
    public Integer getErrcode()
    {
        return errcode;
    }

    public void setErrcode(Integer errcode)
    {
        this.errcode = errcode;
    }

    @Override
    public String getMessage()
    {
        return message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    @Override
    public T getPayload()
    {
        return payload;
    }

    public void setPayload(T payload)
    {
        this.payload = payload;
    }

    //-----------------------------------------------------------------------------------------

    @JsonIgnore
    public boolean isStatusOk()
    {
        return this.status == HttpStatus.OK.value();
    }

    @JsonIgnore
    public boolean isErrcodeOk()
    {
        return this.errcode == ERRCODE_SUCCESS;
    }

    //-----------------------------------------------------------------------------------------


}
