/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.validator.impl.MobileValidator:20190711091157
 *
 * MobileValidator.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.validator.impl;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-07-11 09:11
 * @modify.date     2019-07-11 09:11
 */
public class MobileValidator implements ConstraintValidator<Mobile, String>
{

    //-----------------------------------------------------------------------------------------

    private static final String MOBILE_PATTERN_COMMON = "^(1)\\d{10}$"; //共11位,1开头
    private static final String MOBILE_PATTERN_STRICT = "^[1]([3][0-9]{1}|[5][0-9]{1}|[7][0-9]{1}|[8][0-9]{1}|90|91)[0-9]{8}$";

    private Pattern pattern;

    //-----------------------------------------------------------------------------------------

    private boolean strict;

    @Override
    public void initialize(Mobile parameters)
    {
        this.strict = parameters.strict();
        this.pattern = Pattern.compile(strict?MOBILE_PATTERN_STRICT:MOBILE_PATTERN_COMMON);
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext)
    {
        if (value != null && value.length() != 0)
        {
            Matcher m = this.pattern.matcher(value);
            return m.matches();
        }
        else
        {
            return true;
        }
    }

    //-----------------------------------------------------------------------------------------

}
