/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.aspect;

import cc.zuv.web.support.annotation.LimitedRequest;
import cc.zuv.web.support.utility.WebsPathUtils;
import com.google.gson.Gson;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class LimitReqAspect {
    private static final Logger log = LoggerFactory.getLogger(LimitReqAspect.class);

    @Pointcut(value="@annotation(cc.zuv.web.support.annotation.LimitedRequest)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        if (this.checkLimited(point)) {
            result = point.proceed();
        }
        return result;
    }

    private boolean checkLimited(ProceedingJoinPoint joinPoint) {
        Object[] args;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        LimitedRequest limitedrequest = method.getAnnotation(LimitedRequest.class);
        if (limitedrequest == null) {
            return true;
        }
        long _interval = limitedrequest.interval();
        String cname = joinPoint.getTarget().getClass().getName();
        String mname = signature.getName();
        String _method = cname + "." + mname + "()";
        String _params = null;
        String contentType = request.getContentType();
        if ((contentType == null || contentType.toLowerCase().contains("application/x-www-form-urlencoded") || contentType.toLowerCase().contains("application/json")) && (args = joinPoint.getArgs()) != null && args.length > 0) {
            Object[] newargs = new Object[args.length];
            int i = 0;
            for (Object arg : args) {
                if (arg instanceof ServletResponse || arg instanceof ServletRequest) continue;
                newargs[i++] = arg;
            }
            _params = new Gson().toJson((Object)newargs);
        }
        String _hostip = WebsPathUtils.getClientIp(request);
        String _requri = request.getRequestURI();
        String _reqmtd = request.getMethod();
        return this.checkLimited(_interval, _method, _params, _hostip, _requri, _reqmtd);
    }

    protected abstract boolean checkLimited(long var1, String var3, String var4, String var5, String var6, String var7);
}

