/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.aspect;

import cc.zuv.lang.StringUtils;
import cc.zuv.utility.KeyGenUtils;
import cc.zuv.web.support.annotation.SysLogRender;
import cc.zuv.web.support.enums.SysLogLevel;
import cc.zuv.web.support.enums.SysLogModule;
import cc.zuv.web.support.utility.WebsPathUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    private static final String REQUEST_ID = "$request_id";
    private static final String REQUEST_BEGIN = "$request_begin_time";

    @Pointcut(value="@annotation(cc.zuv.web.support.annotation.SysLogRender)")
    public void logPointCut() {
    }

    private void saveSysLog(JoinPoint joinPoint, long elapse, Object returnval, Exception exception) {
        String _exception;
        Object[] args;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        SysLogRender syslogrender = method.getAnnotation(SysLogRender.class);
        if (syslogrender == null) {
            return;
        }
        SysLogModule _module = syslogrender.module();
        SysLogLevel _level = syslogrender.level();
        String _title = syslogrender.value();
        String _ident = syslogrender.ident();
        String _modulestr = syslogrender.modulestr();
        String _levelstr = syslogrender.levelstr();
        String cname = joinPoint.getTarget().getClass().getName();
        String mname = signature.getName();
        String _method = cname + "." + mname + "()";
        String _params = null;
        String contentType = request.getContentType();
        if ((contentType == null || contentType.toLowerCase().contains("application/x-www-form-urlencoded") || contentType.toLowerCase().contains("application/json")) && (args = joinPoint.getArgs()) != null && args.length > 0) {
            Object[] newargs = new Object[args.length];
            int i = 0;
            for (Object arg : args) {
                if (arg instanceof ServletResponse || arg instanceof ServletRequest) continue;
                newargs[i++] = arg;
            }
            _params = new Gson().toJson((Object)newargs);
        }
        String _hostip = WebsPathUtils.getClientIp(request);
        String _requri = request.getRequestURI();
        String _reqmtd = request.getMethod();
        if (_hostip != null && _hostip.contains(",")) {
            _hostip = _hostip.split(",")[0];
        }
        String _result = returnval == null || returnval instanceof ServletResponse || returnval instanceof ServletRequest || returnval instanceof OutputStream || returnval instanceof InputStream || returnval instanceof File ? null : new Gson().toJson(returnval);
        String string = _exception = exception != null ? exception.getMessage() : "OK";
        if (StringUtils.NotEmpty((String)_levelstr) && StringUtils.NotEmpty((String)_modulestr)) {
            this.saveSysLog(_levelstr, _modulestr, _title, _ident, _method, _params, _hostip, _requri, _reqmtd, elapse, _result, _exception);
        } else {
            this.saveSysLog(_level, _module, _title, _ident, _method, _params, _hostip, _requri, _reqmtd, elapse, _result, _exception);
        }
    }

    protected abstract void saveSysLog(SysLogLevel var1, SysLogModule var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, long var10, String var12, String var13);

    protected abstract void saveSysLog(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, long var10, String var12, String var13);

    @Before(value="logPointCut()")
    public void doBefore(JoinPoint point) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestid = KeyGenUtils.uuid();
        request.setAttribute(REQUEST_ID, (Object)requestid);
        long beginTime = System.currentTimeMillis();
        request.setAttribute(REQUEST_BEGIN, (Object)beginTime);
        String sessionid = request.getSession().getId();
        String requesturi = request.getRequestURI();
        log.info("request: id={}, session= {}, requesturi={}", new Object[]{requestid, sessionid, requesturi});
    }

    @AfterReturning(returning="ret", pointcut="logPointCut()")
    public void doAfterReturning(JoinPoint point, Object ret) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestid = (String)request.getAttribute(REQUEST_ID);
        Long requestbegin = (Long)request.getAttribute(REQUEST_BEGIN);
        String sessionid = request.getSession().getId();
        String retrunval = new Gson().toJson(ret);
        log.info("response: id={}, session= {}, ret={}", new Object[]{requestid, sessionid, retrunval});
        long elapse = System.currentTimeMillis() - requestbegin;
        this.saveSysLog(point, elapse, ret, null);
    }

    @AfterThrowing(pointcut="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint point, Exception e) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestid = (String)request.getAttribute(REQUEST_ID);
        Long requestbegin = (Long)request.getAttribute(REQUEST_BEGIN);
        String sessionid = request.getSession().getId();
        String message = e.getMessage();
        log.info("throwing: id={}, session= {}, message={}", new Object[]{requestid, sessionid, message});
        long elapse = System.currentTimeMillis() - requestbegin;
        this.saveSysLog(point, elapse, null, e);
    }
}

