/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.captcha.kaptcha;

import cc.zuv.web.support.captcha.kaptcha.KaptchaProperties;
import cc.zuv.web.support.captcha.kaptcha.KaptchaService;
import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KaptchaProperties.class})
public class KaptchaConfig {
    @Autowired
    private KaptchaProperties properties;

    @Bean
    public DefaultKaptcha producer() {
        Properties prop = new Properties();
        prop.put("kaptcha.border", this.properties.isBorder() ? "yes" : "no");
        prop.put("kaptcha.textproducer.font.color", this.properties.getFontColor());
        prop.put("kaptcha.textproducer.char.space", (Object)this.properties.getCharSpace());
        prop.put("kaptcha.image.width", (Object)this.properties.getWidth());
        prop.put("kaptcha.image.height", (Object)this.properties.getHeight());
        Config config = new Config(prop);
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }

    @Bean
    public KaptchaService kaptchaService(Producer producer) {
        long expired = this.properties.getExpired();
        int length = this.properties.getLength();
        return new KaptchaService(producer, expired, length);
    }
}

