/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.captcha.kaptcha;

import cc.zuv.ZuvException;
import cc.zuv.lang.StringUtils;
import cc.zuv.utility.RandomUtils;
import cc.zuv.web.support.captcha.CaptchaCode;
import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KaptchaService {
    private static final Logger log = LoggerFactory.getLogger(KaptchaService.class);
    public static final String SESSION_KEY_KAPTCHA_CODE = "SESSION_KEY_KAPTCHA_CODE";
    private Producer producer;
    private long expired;
    private int length;

    public KaptchaService(Producer producer, long expired, int length) {
        this.producer = producer;
        this.expired = expired <= 0L ? 60L : expired;
        this.length = length <= 0 ? 4 : length;
        log.debug("expired {} seconds, length {} chars", (Object)this.expired, (Object)this.length);
    }

    public BufferedImage generateCaptcha(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String sessionid = session.getId();
        String captcha = RandomUtils.randomAlphanumeric((int)this.length);
        long expired = System.currentTimeMillis() + this.expired * 1000L;
        if (log.isDebugEnabled()) {
            log.debug("generate captcha {} {} {}", new Object[]{sessionid, captcha, expired});
        }
        CaptchaCode cc = new CaptchaCode();
        cc.setCode(captcha);
        cc.setExpiredAtTime(expired);
        session.setAttribute(SESSION_KEY_KAPTCHA_CODE, (Object)cc);
        return this.producer.createImage(captcha);
    }

    public boolean validateCaptcha(HttpServletRequest request, String captcha) {
        HttpSession session = request.getSession();
        String sessionid = session.getId();
        Object value = session.getAttribute(SESSION_KEY_KAPTCHA_CODE);
        if (value == null) {
            throw new ZuvException("\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728");
        }
        if (StringUtils.IsEmpty((String)captcha)) {
            throw new ZuvException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        CaptchaCode cc = (CaptchaCode)value;
        String code = cc.getCode();
        long expired = cc.getExpiredAtTime();
        if (log.isDebugEnabled()) {
            log.debug("validate captcha {} {} {} {}", new Object[]{sessionid, captcha, code, expired});
        }
        if (!captcha.equalsIgnoreCase(cc.getCode())) {
            log.info("\u9a8c\u8bc1\u7801\u9519\u8bef");
            throw new ZuvException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        if (cc.isExpired()) {
            session.removeAttribute(SESSION_KEY_KAPTCHA_CODE);
            log.info("\u9a8c\u8bc1\u7801\u8fc7\u671f");
            throw new ZuvException("\u9a8c\u8bc1\u7801\u8fc7\u671f");
        }
        session.removeAttribute(SESSION_KEY_KAPTCHA_CODE);
        return true;
    }
}

