/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.utility;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtils {
    public static void setCookie(HttpServletResponse res, String name, String value) {
        CookieUtils.setCookie(res, name, value, 43200, null);
    }

    public static void setCookie(HttpServletResponse res, String name, String value, String domain) {
        CookieUtils.setCookie(res, name, value, 43200, domain);
    }

    public static void setCookie(HttpServletResponse res, String name, String value, int expire, String domain) {
        Cookie _cookie = new Cookie(name, value);
        if (domain != null) {
            _cookie.setDomain(domain);
        }
        _cookie.setMaxAge(expire);
        _cookie.setPath("/");
        res.addCookie(_cookie);
    }

    public static void delCookie(HttpServletResponse res, String name, String domain) {
        Cookie _cookie = new Cookie(name, null);
        if (domain != null) {
            _cookie.setDomain(domain);
        }
        _cookie.setMaxAge(0);
        _cookie.setPath("/");
        res.addCookie(_cookie);
    }

    public static String getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        String out = null;
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            out = cookie.getValue();
            break;
        }
        return out;
    }

    public static boolean isSupportCookie(HttpServletRequest req, HttpServletResponse res) {
        res.addCookie(new Cookie("cookiesupport", "true"));
        Cookie[] cookies = req.getCookies();
        return cookies != null && cookies.length > 0;
    }
}

