/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.utility;

import cc.zuv.ios.Resourcer;
import cc.zuv.lang.StringUtils;
import cc.zuv.utility.CodecUtils;
import cc.zuv.utility.MimeUtils;
import cc.zuv.web.support.payload.RestResult;
import cc.zuv.web.support.utility.CookieUtils;
import cc.zuv.web.support.utility.WebsPathUtils;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRenderUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpRenderUtils.class);

    public static boolean require_json(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().contains("application/json");
    }

    public static boolean require_xml(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().contains("application/xml");
    }

    public static void render_json(HttpServletRequest request, HttpServletResponse response, int status, int errcode, String message) throws IOException {
        String epoint = request.getRequestURI();
        String method = request.getMethod();
        RestResult result = new RestResult(status, epoint, method, errcode, message);
        HttpRenderUtils.render_content(response, status, "application/json; charset=utf-8", result);
    }

    public static void render_xml(HttpServletRequest request, HttpServletResponse response, int status, int errcode, String message) throws IOException {
        String epoint = request.getRequestURI();
        String method = request.getMethod();
        RestResult result = new RestResult(status, epoint, method, errcode, message);
        HttpRenderUtils.render_content(response, status, "text/xml; charset=utf-8", result);
    }

    public static void render_html(HttpServletResponse response, String html) throws IOException {
        HttpRenderUtils.render_content(response, "text/html; charset=utf-8", html);
    }

    public static void render_text(HttpServletResponse response, String txt) throws IOException {
        HttpRenderUtils.render_content(response, "text/plain; charset=utf-8", txt);
    }

    public static void render_xml(HttpServletResponse response, String xml) throws IOException {
        HttpRenderUtils.render_content(response, "text/xml; charset=utf-8", xml);
    }

    public static void render_json(HttpServletResponse response, String json) throws IOException {
        HttpRenderUtils.render_content(response, "application/json; charset=utf-8", json);
    }

    public static void render_markdown(HttpServletResponse response, String md) throws IOException {
        HttpRenderUtils.render_content(response, "text/x-markdown; charset=utf-8", md);
    }

    public static void render_content(HttpServletResponse response, String mime, String content) throws IOException {
        response.setContentType(mime);
        PrintWriter writer = response.getWriter();
        writer.println(content);
        writer.close();
    }

    public static void render_content(HttpServletResponse response, int status, String mime, String content) throws IOException {
        response.setStatus(status);
        response.setContentType(mime);
        PrintWriter writer = response.getWriter();
        writer.println(content);
        writer.close();
    }

    public static void render_html(HttpServletResponse response, RestResult rest) throws IOException {
        HttpRenderUtils.render_content(response, "text/html; charset=utf-8", rest);
    }

    public static void render_text(HttpServletResponse response, RestResult rest) throws IOException {
        HttpRenderUtils.render_content(response, "text/plain; charset=utf-8", rest);
    }

    public static void render_xml(HttpServletResponse response, RestResult rest) throws IOException {
        HttpRenderUtils.render_content(response, "text/xml; charset=utf-8", rest);
    }

    public static void render_json(HttpServletResponse response, RestResult rest) throws IOException {
        HttpRenderUtils.render_content(response, "application/json; charset=utf-8", rest);
    }

    public static void render_content(HttpServletResponse response, String mime, RestResult rest) throws IOException {
        response.setContentType(mime);
        PrintWriter writer = response.getWriter();
        writer.println(new Gson().toJson((Object)rest));
        writer.close();
    }

    public static void render_content(HttpServletResponse response, int status, String mime, RestResult rest) throws IOException {
        response.setStatus(status);
        response.setContentType(mime);
        PrintWriter writer = response.getWriter();
        writer.println(new Gson().toJson((Object)rest));
        writer.close();
    }

    public static void redirect(HttpServletResponse response, String uri) throws IOException {
        response.sendRedirect(uri);
    }

    public static void render_mime(HttpServletResponse response, String filename) {
        String mime = MimeUtils.queryMimeByFileName((String)filename);
        response.setContentType(StringUtils.IsEmpty((String)mime) ? "application/octet-stream" : mime);
    }

    public static void render_mime(HttpServletResponse response, String filename, File file) throws IOException {
        String mime = MimeUtils.queryMimeByFileName((String)filename);
        response.setContentType(StringUtils.IsEmpty((String)mime) ? "application/octet-stream" : mime);
        ServletOutputStream os = response.getOutputStream();
        Resourcer.copy((File)file, (OutputStream)os);
    }

    public static void download_mime(HttpServletResponse response, String filename) throws IOException {
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode((String)filename));
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", disp);
    }

    public static void download_mime(HttpServletResponse response, String filename, File file) throws IOException {
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode((String)filename));
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", disp);
        ServletOutputStream os = response.getOutputStream();
        Resourcer.copy((File)file, (OutputStream)os);
    }

    public static void download_mime(HttpServletResponse response, String filename, InputStream is) throws IOException {
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode((String)filename));
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", disp);
        ServletOutputStream os = response.getOutputStream();
        Resourcer.copy((InputStream)is, (OutputStream)os);
    }

    public static void render_image(HttpServletResponse response, BufferedImage image) throws IOException {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        out.close();
    }

    public static void render_redirect(HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(url);
    }

    public static String verbose(HttpServletRequest request, HttpServletResponse response, boolean isdebug, String sessionname, String cookiename) {
        StringBuilder sb = new StringBuilder();
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = request.getSession(true);
        }
        session.setMaxInactiveInterval(2000);
        String sessid = session.getId();
        boolean isnew = session.isNew();
        long createtime = session.getCreationTime();
        long laccesstime = session.getLastAccessedTime();
        int maxinactive = session.getMaxInactiveInterval();
        log.info("[Session] : ID=" + sessid + ",New=" + isnew + ",Create=" + createtime + ",Access=" + laccesstime + ",Inactive=" + maxinactive);
        if (session.getAttribute(sessionname) != null) {
            boolean session_visited = (Boolean)session.getAttribute(sessionname);
            log.info("[Session] : " + session_visited);
        }
        if (isdebug) {
            session.setAttribute(sessionname, (Object)true);
        }
        sb.append("[Session] : ").append(sessid).append("<br/>");
        String cookie_visited = CookieUtils.getCookie(request, cookiename);
        log.info("[Cookie] : " + cookie_visited);
        if (isdebug) {
            CookieUtils.setCookie(response, cookiename, "true", null);
        }
        sb.append("[Cookie] : ").append(cookie_visited).append("<br/>");
        String referer = request.getHeader("referer");
        String useragent = request.getHeader("user-agent");
        String address = WebsPathUtils.getClientIp(request);
        log.info("[Header] : " + referer + "," + useragent + "," + address);
        sb.append("[Header] <br/>");
        sb.append("referer : ").append(referer).append("<br/>");
        sb.append("useragent : ").append(useragent).append("<br/>");
        sb.append("address : ").append(address).append("<br/>");
        String urls = request.getRequestURL().toString();
        String uris = request.getRequestURI();
        String path = request.getServletPath();
        String para = request.getQueryString();
        String content = request.getContextPath();
        String selfurl = para != null ? urls + "?" + para : urls;
        log.info("[Request] : " + urls + "," + uris + "," + path + "," + content + "," + selfurl);
        sb.append("[Request] <br/>");
        sb.append("urls : ").append(urls).append("<br/>");
        sb.append("uris : ").append(uris).append("<br/>");
        sb.append("path : ").append(path).append("<br/>");
        sb.append("para : ").append(para).append("<br/>");
        sb.append("content : ").append(content).append("<br/>");
        sb.append("selfurl : ").append(selfurl).append("<br/>");
        return sb.toString();
    }
}

