/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.utility;

import cc.zuv.ZuvException;
import cc.zuv.lang.StringUtils;
import cc.zuv.utility.OsEnvUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;

public class WebsPathUtils {
    public static final String TEMP_FOLDER = "tmp";

    public static String getServerUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String header_scheme = request.getHeader("X-Forwarded-Proto");
        if (StringUtils.NotEmpty((String)header_scheme) && ("http".equalsIgnoreCase(header_scheme) || "https".equalsIgnoreCase(header_scheme))) {
            scheme = header_scheme;
        }
        return WebsPathUtils.getServerUrl(request, scheme);
    }

    public static String getServerUrl(HttpServletRequest request, String scheme) {
        return scheme + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.IsEmpty((String)ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.IsEmpty((String)ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.IsEmpty((String)ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getServletRootDir(HttpServletRequest request) {
        return request.getSession().getServletContext().getRealPath("");
    }

    public static File getServletTempDir(HttpServletRequest request) {
        String temp = WebsPathUtils.getServletRootDir(request) + OsEnvUtils.FILE_SEPARATOR + TEMP_FOLDER;
        File tempdir = new File(temp);
        if (!tempdir.exists() && !tempdir.mkdirs()) {
            throw new ZuvException("\u4e34\u65f6\u76ee\u5f55\u521b\u5efa\u5931\u8d25 {}", new Object[]{temp});
        }
        return tempdir;
    }
}

