/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.validator;

import cc.zuv.web.support.IWebERRCode;
import cc.zuv.web.support.exception.RestBadRequestException;
import cc.zuv.web.support.exception.RestException;
import cc.zuv.web.support.exception.RestHasExistsException;
import cc.zuv.web.support.exception.RestNotFoundException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertUtil {
    private static final Logger log = LoggerFactory.getLogger(AssertUtil.class);

    public static void assertTrue(boolean value, String message) {
        if (value) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotBetween(byte min, byte max, byte value, String message) {
        if (value < min || value >= max) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotBetween(int min, int max, int value, String message) {
        if (value < min || value >= max) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotBetween(long min, long max, long value, String message) {
        if (value < min || value >= max) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(String value, String message) {
        if (value == null || value.trim().length() == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(Collection collection, String message) {
        if (collection == null || collection.size() == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(Map map, String message) {
        if (map == null || map.size() == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Long value, String message) {
        if (value == null || value == 0L) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Integer value, String message) {
        if (value == null || value == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Short value, String message) {
        if (value == null || value == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Byte value, String message) {
        if (value == null || value == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNull(Object value, String message) {
        if (value == null) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotFound(Object value, String message) {
        if (value == null) {
            throw new RestNotFoundException(message);
        }
    }

    public static void assertHasExist(Object value, String message) {
        if (value != null) {
            throw new RestHasExistsException(message);
        }
    }

    public static void assertNotFound(boolean found, String message) {
        if (!found) {
            throw new RestNotFoundException(message);
        }
    }

    public static void assertHasExist(boolean exist, String message) {
        if (exist) {
            throw new RestHasExistsException(message);
        }
    }

    public static void assertError(IWebERRCode errcode) {
        throw new RestException(errcode);
    }

    public static void assertError(IWebERRCode errcode, String message, Object ... params) {
        throw new RestException(errcode, message, params);
    }

    public static void assertError(boolean value, IWebERRCode errcode) {
        if (value) {
            throw new RestException(errcode);
        }
    }

    public static void assertError(boolean value, IWebERRCode errcode, String message, Object ... params) {
        if (value) {
            throw new RestException(errcode, message, params);
        }
    }
}

