/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.validator.impl;

import cc.zuv.web.support.validator.impl.Mobile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MobileValidator
implements ConstraintValidator<Mobile, String> {
    private static final String MOBILE_PATTERN_COMMON = "^(1)\\d{10}$";
    private static final String MOBILE_PATTERN_STRICT = "^[1]([3][0-9]{1}|[5][0-9]{1}|[7][0-9]{1}|[8][0-9]{1}|90|91)[0-9]{8}$";
    private Pattern pattern;
    private boolean strict;

    public void initialize(Mobile parameters) {
        this.strict = parameters.strict();
        this.pattern = Pattern.compile(this.strict ? MOBILE_PATTERN_STRICT : MOBILE_PATTERN_COMMON);
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value != null && value.length() != 0) {
            Matcher m = this.pattern.matcher(value);
            return m.matches();
        }
        return true;
    }
}

