/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.webconfig.localeresolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
public class LocaleResolverConfig
extends WebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(LocaleResolverConfig.class);

    @Bean(value={"localeResolver"})
    public LocaleResolver sessionLocaleResolver() {
        log.info("SessionLocaleResolver");
        return new SessionLocaleResolver();
    }

    @Bean
    public LocaleResolver cookieLocaleResolver() {
        log.info("CookieLocaleResolver");
        return new CookieLocaleResolver();
    }

    @Bean
    public LocaleResolver acceptHeaderLocaleResolver() {
        log.info("AcceptHeaderLocaleResolver");
        return new AcceptHeaderLocaleResolver();
    }

    private LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("locale");
        return localeChangeInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
    }
}

