/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.aspect.LimitReqAspect:20181226101928
 *
 * LimitReqAspect.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.aspect;

import cc.zuv.web.support.annotation.LimitedRequest;
import cc.zuv.web.support.utility.HttpRequestUtils;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

/**
 * 重复提交切面处理
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
public abstract class LimitReqAspect
{

    //-----------------------------------------------------------------------------------------

	@Pointcut("@annotation(cc.zuv.web.support.annotation.LimitedRequest)")
	public void logPointCut()
    {

	}

	@Around("logPointCut()")
	public Object around(ProceedingJoinPoint point) throws Throwable
    {
        Object result = null;
        if(checkLimited(point))
        {
            result = point.proceed();
        }
        return result;
	}

    //-----------------------------------------------------------------------------------------

    //是否通过(是否不是重复提交)
	private boolean checkLimited(ProceedingJoinPoint joinPoint)
    {
        //
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();

        //
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        LimitedRequest limitedrequest = method.getAnnotation(LimitedRequest.class);

        if(limitedrequest==null) return true; //无注解不校验

        //注解的内容
        long        _interval   = limitedrequest.interval();

        //请求的方法
        String cname = joinPoint.getTarget().getClass().getName();
        String mname = signature.getName();
        String _method = cname + "." + mname + "()";

        //请求的参数
        String _params = null;
        String contentType = request.getContentType();
        if (contentType == null
            || contentType.toLowerCase().contains(MediaType.APPLICATION_FORM_URLENCODED_VALUE)
            || contentType.toLowerCase().contains(MediaType.APPLICATION_JSON_VALUE))
        {
            Object[] args = joinPoint.getArgs();
            if(args!=null && args.length>0)
            {
                Object[] newargs = new Object[args.length];

                int i = 0;
                for(Object arg : args)
                {
                    if(arg instanceof ServletResponse || arg instanceof ServletRequest)
                    {
                        continue;
                    }
                    newargs[i++] = arg;
                }

                _params = new Gson().toJson(newargs);
            }
        }

        //请求的地址
        String _hostip = HttpRequestUtils.getClientIp(request);
        String _requri = request.getRequestURI();
        String _reqmtd = request.getMethod();

        return checkLimited(_interval, _method, _params, _hostip, _requri, _reqmtd);
	}

    protected abstract boolean checkLimited(long inverval, String method, String params, String hostip, String requri, String reqmtd);

    //-----------------------------------------------------------------------------------------

}
