/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.captcha.kaptcha.KaptchaConfig:20190102095522
 *
 * KaptchaConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.captcha.kaptcha;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * KaptchaConfig
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Configuration
@EnableConfigurationProperties(KaptchaProperties.class)
public class KaptchaConfig
{

    //-----------------------------------------------------------------------------------------

    /*
    <prop key="kaptcha.border.color">105,179,90</prop>
    <prop key="kaptcha.textproducer.font.color">blue</prop>
    <prop key="kaptcha.image.width">100</prop>
    <prop key="kaptcha.image.height">50</prop>
    <prop key="kaptcha.textproducer.font.size">27</prop>
    <prop key="kaptcha.session.key">code</prop>
    <prop key="kaptcha.textproducer.char.length">4</prop>
    <prop key="kaptcha.textproducer.font.names">宋体,楷体,微软雅黑</prop>
    <prop key="kaptcha.textproducer.char.string">0123456789ABCEFGHIJKLMNOPQRSTUVWXYZ</prop>
    <prop key="kaptcha.obscurificator.impl">com.google.code.kaptcha.impl.WaterRipple</prop>
    <prop key="kaptcha.noise.color">black</prop>
    <prop key="kaptcha.noise.impl">com.google.code.kaptcha.impl.DefaultNoise</prop>
    <prop key="kaptcha.background.clear.from">185,56,213</prop>
    <prop key="kaptcha.background.clear.to">white</prop>
    <prop key="kaptcha.textproducer.char.space">3</prop>
    */

    //-----------------------------------------------------------------------------------------

    @Autowired
    private KaptchaProperties properties;

    //-----------------------------------------------------------------------------------------

    @Bean
    public DefaultKaptcha producer()
    {
        Properties prop = new Properties();
        prop.put("kaptcha.border", properties.isBorder()?"yes":"no");
        prop.put("kaptcha.textproducer.font.color", properties.getFontColor());
        prop.put("kaptcha.textproducer.char.space", properties.getCharSpace());
        prop.put("kaptcha.image.width", properties.getWidth());
        prop.put("kaptcha.image.height", properties.getHeight());
        Config config = new Config(prop);
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }

    @Bean
    public KaptchaService kaptchaService(Producer producer)
    {
        long expired = properties.getExpired(); //second
        int length = properties.getLength();
        return new KaptchaService(producer, expired, length);
    }

    //-----------------------------------------------------------------------------------------

}
