/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.template.WebTplRender:20190104094721
 *
 * WebTplRender.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.template;

import cc.zuv.IERRCode;
import org.springframework.ui.Model;

import java.util.Date;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-04 09:47
 * @modify.date     2019-01-04 09:47
 */
public class WebTplRender implements IWebTplCode, IERRCode
{

    //-----------------------------------------------------------------------------------------

    public static Model merge(Model model, int errcode, String message, String title, String content)
    {
        model.addAttribute(TPL_KEY_ERRCODE, errcode);
        model.addAttribute(TPL_KEY_MESSAGE, message);
        model.addAttribute(TPL_KEY_TITLE, title);
        model.addAttribute(TPL_KEY_STAMP, new Date());
        model.addAttribute(TPL_KEY_CONTENT, content);
        return model;
    }

    public static Model merge(Model model, String title, String content)
    {
        return merge(model, ERRCODE_SUCCESS, MESSAGE_SUCCESS, title, content);
    }

    public static Model success(Model model)
    {
        return merge(model, ERRCODE_SUCCESS, MESSAGE_SUCCESS, MESSAGE_SUCCESS, MESSAGE_SUCCESS);
    }

    public static Model failure(Model model)
    {
        return merge(model, ERRCODE_FAILURE, MESSAGE_FAILURE, MESSAGE_FAILURE, MESSAGE_FAILURE);
    }

    //-----------------------------------------------------------------------------------------


}
