/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.webconfig.localeresolver.LocaleResolverConfig:20190710112221
 *
 * LocaleResolverConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.webconfig.localeresolver;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

import java.util.Locale;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-07-10 11:22
 * @modify.date     2019-07-10 11:22
 */
@Slf4j
@Configuration
public class LocaleResolverConfig extends WebMvcConfigurerAdapter
{

    //-----------------------------------------------------------------------------------------

    //方法名必须为 localeResolver()

    // curl -H "Accept-Language: zh-CN" http://localhost:9101/freemarker
    // curl -H "Accept-Language: en-US" http://localhost:9101/freemarker
    // curl http://localhost:9101/freemarker?locale=en_US
    // curl http://localhost:9101/freemarker?locale=zh_CN
    // curl -H "Accept-Language: zh-CN" http://localhost:9101/freemarker?locale=en_US,  locale优先级高,显示en_US
    @Bean("localeResolver")
//    public LocaleResolver localeResolver()
    public LocaleResolver sessionLocaleResolver()
    {
        log.info("SessionLocaleResolver");
//        SessionLocaleResolver resolver = new SessionLocaleResolver();
//        resolver.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return new SessionLocaleResolver();
    }

    @Bean
    public LocaleResolver cookieLocaleResolver()
    {
        log.info("CookieLocaleResolver");
//        CookieLocaleResolver resolver = new CookieLocaleResolver();
//        resolver.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return new CookieLocaleResolver();
    }


    // curl -H "Accept-Language: zh-CN" http://localhost:9101/freemarker
    // curl -H "Accept-Language: en-US" http://localhost:9101/freemarker
    @Bean
    public LocaleResolver acceptHeaderLocaleResolver()
    {
        log.info("AcceptHeaderLocaleResolver");
//        AcceptHeaderLocaleResolver resolver = new AcceptHeaderLocaleResolver();
//        resolver.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return new AcceptHeaderLocaleResolver();
    }

    // curl http://localhost:9101/freemarker?locale=en_US
    // curl http://localhost:9101/freemarker?locale=zh_CN
    private LocaleChangeInterceptor localeChangeInterceptor()
    {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("locale");
        return localeChangeInterceptor;
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry)
    {
        registry.addInterceptor(localeChangeInterceptor());
    }

    //-----------------------------------------------------------------------------------------

}
