/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.captcha.kaptcha.KaptchaService:20190102095522
 *
 * KaptchaService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.captcha.kaptcha;

import cc.zuv.ZuvException;
import cc.zuv.lang.StringUtils;
import cc.zuv.utility.RandomUtils;
import cc.zuv.web.support.captcha.CaptchaCode;
import cc.zuv.web.support.exception.RestException;
import com.google.code.kaptcha.Producer;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.awt.image.BufferedImage;

/**
 * Kaptcha
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
public class KaptchaService
{

    //-----------------------------------------------------------------------------------------

    public final static String SESSION_KEY_KAPTCHA_CODE = "SESSION_KEY_KAPTCHA_CODE";

    //-----------------------------------------------------------------------------------------

    private Producer producer;
    private long expired;
    private int length;

    public KaptchaService(Producer producer, long expired, int length)
    {
        this.producer = producer;
        this.expired = expired<=0?60L:expired;
        this.length = length<=0?4:length;
        log.debug("expired {} seconds, length {} chars", this.expired, this.length);
    }

    //-----------------------------------------------------------------------------------------

    /*
     * 生成验证码
     */
    public BufferedImage generateCaptcha(HttpServletRequest request)
    {
        //
        HttpSession session = request.getSession(true);
        String sessionid = session.getId();
        String captcha = RandomUtils.randomAlphabetic(length); //producer.createText();
        long expired = System.currentTimeMillis() + this.expired * 1000;
        if(log.isDebugEnabled())
        {
            log.debug("generate captcha {} {} {}", sessionid, captcha, expired);
        }

        //
        CaptchaCode cc = new CaptchaCode();
        cc.setCode(captcha);
        cc.setExpiredAtTime(expired);
        session.setAttribute(SESSION_KEY_KAPTCHA_CODE, cc);
        return producer.createImage(captcha);
    }

    /*
     * 验证码校验
     */
    public boolean validateCaptcha(HttpServletRequest request, String captcha)
    {
        HttpSession session = request.getSession();
        String sessionid = session.getId();
        Object value = session.getAttribute(SESSION_KEY_KAPTCHA_CODE);
        if(value==null)
        {
            throw new ZuvException("验证码不存在");
        }

        if(StringUtils.IsEmpty(captcha))
        {
            throw new ZuvException("验证码为空");
        }

        //
        CaptchaCode cc = (CaptchaCode)value;
        String code = cc.getCode();
        long expired = cc.getExpiredAtTime();
        if(log.isDebugEnabled())
        {
            log.debug("validate captcha {} {} {} {}", sessionid, captcha, code, expired);
        }

        //
        if(!captcha.equalsIgnoreCase(cc.getCode()))
        {
            log.info("验证码错误");
            throw new ZuvException("验证码错误");
        }

        //
        if(cc.isExpired())
        {
            session.removeAttribute(SESSION_KEY_KAPTCHA_CODE);
            log.info("验证码过期");
            throw new ZuvException("验证码过期");
        }

        session.removeAttribute(SESSION_KEY_KAPTCHA_CODE);
        return true;
    }

    //-----------------------------------------------------------------------------------------

}
