/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.payload.base.PayloadList:20181225110811
 *
 * PayloadList.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */
package cc.zuv.web.support.payload.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Getter
@Setter
@ToString
public class PayloadList<T>
{

    //-----------------------------------------------------------------------------------------

    public PayloadList()
    {

    }

    public PayloadList(List<T> list, long count)
    {
        this.list = list;
        this.count = count;
    }

    public PayloadList(List<T> list, long count, Integer page, Integer size)
    {
        this.list = list;
        this.count = count;
        this.page = page;
        this.size = size;
    }

    //-----------------------------------------------------------------------------------------

    @ApiModelProperty(value = "总记录数")
    private long    count;

    @ApiModelProperty(value = "记录列表")
    private List<T> list;

    @ApiModelProperty(value = "当前页数")
    private Integer page;

    @ApiModelProperty(value = "每页数量")
    private Integer size;

    //-----------------------------------------------------------------------------------------

}
