/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.redislock.RedisLockAspect:20201202221317
 *
 * RedisLockAspect.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.redislock;

import cc.zuv.web.support.utility.SpelUtils;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * 分布式锁
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
@Aspect
@Component
public abstract class RedisLockAspect
{

    //-----------------------------------------------------------------------------------------

    private static final String REDISSON_LOCK_PREFIX = "redisson_lock:";

    //-----------------------------------------------------------------------------------------

    @Autowired
    private RedissonClient redissonClient;

    //-----------------------------------------------------------------------------------------

    @Pointcut("@annotation(cc.zuv.web.support.redislock.RedisLock)")
    public void logPointCut()
    {

    }

    @Around("logPointCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable
    {
        //
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        RedisLock redisLock = method.getAnnotation(RedisLock.class);

        if(redisLock==null) return true; //无注解不校验


        String lockName = redisLock.lockName();
        String spel = redisLock.key();

        RLock rLock = redissonClient.getLock(getRedisKey(joinPoint, lockName, spel));
        rLock.lock(redisLock.expire(),redisLock.timeUnit());

        Object result;
        try
        {
            result = joinPoint.proceed(); //执行方法
        }
        finally
        {
            rLock.unlock();
        }
        return result;
    }

    /*
    @Around("@annotation(redisLock)")
    public Object around(ProceedingJoinPoint joinPoint, RedisLock redisLock)
        throws Throwable
    {
        String lockName = redisLock.lockName();
        String spel = redisLock.key();

        RLock rLock = redissonClient.getLock(getRedisKey(joinPoint, lockName, spel));
        rLock.lock(redisLock.expire(),redisLock.timeUnit());

        Object result;
        try
        {
            result = joinPoint.proceed(); //执行方法
        }
        finally
        {
            rLock.unlock();
        }
        return result;
    }*/

    /**
     * 将spel表达式转换为字符串
     * @param joinPoint 切点
     * @return redisKey
     */
    private String getRedisKey(ProceedingJoinPoint joinPoint, String lockName, String spel)
    {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method targetMethod = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        Object[] arguments = joinPoint.getArgs();
        return REDISSON_LOCK_PREFIX + lockName + ":" + SpelUtils.parse(target,spel, targetMethod, arguments);
    }

    //-----------------------------------------------------------------------------------------

}
