/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.redislock.RedissonConfig:20201203115418
 *
 * RedissonConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.redislock;

import cc.zuv.lang.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
//import org.springframework.boot.context.properties.ConfigurationProperties;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2020-12-03 11:54
 * @modify.date     2020-12-03 11:54
 */
//@Configuration
//@ConfigurationProperties(prefix = "spring.redis")
public class RedissonConfig 
{

    //-----------------------------------------------------------------------------------------

    /*
        <dependency>
            <groupId>org.redisson</groupId>
            <artifactId>redisson</artifactId>
            <version>3.5.0</version>
        </dependency>
     */

    //-----------------------------------------------------------------------------------------

    private String host;
    private String port;
    private String password;
    private int database;

//    @Bean
    public RedissonClient getRedisson()
    {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + host + ":" + port).setDatabase(database);
        if (StringUtils.NotEmpty(password))
        {
            config.useSingleServer().setPassword(password);
        }
        return Redisson.create(config);
    }

    //-----------------------------------------------------------------------------------------

}
