/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.utility.HttpRequestUtils:20181225110811
 *
 * HttpRequestUtils.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.utility;

import cc.zuv.ZuvException;
import cc.zuv.lang.StringUtils;
import cc.zuv.utility.OsEnvUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.File;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-18 21:06
 * @modify.date     2018-12-18 21:06
 */
public class HttpRequestUtils
{


    //-----------------------------------------------------------------------------------------

    /**
     * 获取应用的客户端UA
     * @param request 请求
     * @return 客户端UA
     */
    public static String getUserAgent(HttpServletRequest request)
    {
        return request.getHeader("User-Agent");
    }

    /**
     * 获取应用的客户端请求来源
     * @param request 请求
     * @return 客户端请求来源
     */
    public static String getReferer(HttpServletRequest request)
    {
        return request.getHeader("Referer");
    }

    /**
     * 获取应用的客户端地址
     * @param request 请求
     * @return 客户端地址
     */
    public static String getClientIp(HttpServletRequest request)
    {
        String ip = request.getHeader("X-Forwarded-For");
        if(StringUtils.IsEmpty(ip))
        {
            ip = request.getHeader("X-Real-IP");
        }
        if(StringUtils.IsEmpty(ip))
        {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if(StringUtils.IsEmpty(ip))
        {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    //-----------------------------------------------------------------------------------------

    /**
     * 获取应用的服务地址(scheme://servername:serverport/context)
     * @param request 请求
     * @return 服务地址
     */
    public static String getServerUrl(HttpServletRequest request)
    {
        String scheme = request.getScheme();
        String header_scheme = request.getHeader("X-Forwarded-Proto");
        if(StringUtils.NotEmpty(header_scheme) && ("http".equalsIgnoreCase(header_scheme) || "https".equalsIgnoreCase(header_scheme) ))
        {
            scheme = header_scheme;
        }

        return getServerUrl(request, scheme);
    }

    /**
     * 获取应用的服务地址(scheme://servername:serverport/context)
     * @param request 请求
     * @param scheme 协议
     * @return 服务地址
     */
    public static String getServerUrl(HttpServletRequest request, String scheme)
    {
        return scheme + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }


    /**
     * 获取服务器基础地址(scheme://servername:serverport)
     * @param request 请求
     * @return 基础地址
     */
    public static String getServerName(HttpServletRequest request)
    {
        String scheme = request.getScheme();
        String header_scheme = request.getHeader("X-Forwarded-Proto");
        if(StringUtils.NotEmpty(header_scheme) && ("http".equalsIgnoreCase(header_scheme) || "https".equalsIgnoreCase(header_scheme) ))
        {
            scheme = header_scheme;
        }

        return getServerName(request, scheme);
    }

    /**
     * 获取服务器基础地址(scheme://servername:serverport)
     * @param request 请求
     * @param scheme 协议
     * @return 基础地址
     */
    public static String getServerName(HttpServletRequest request, String scheme)
    {
        return scheme + "://" + request.getServerName() + ":" + request.getServerPort();
    }


    /**
     * 获取应用的根路径
     * @param request 请求
     * @return 根路径
     */
    public static String getServletRootDir(HttpServletRequest request)
    {
        /*
        Resource res = new ServletContextResource(request.getSession().getServletContext(), "");
        try
        {
            return res.getFile().getAbsolutePath();
        }
        catch (IOException e)
        {
            return request.getSession().getServletContext().getRealPath("");
        }
        */
        return request.getSession().getServletContext().getRealPath("");  // ""或"/"  对应返回值为 ""或"/"
    }

    /**
     * 获取应用的临时目录
     * @param request 请求
     * @return 临时目录
     */
    public static File getServletTempDir(HttpServletRequest request)
    {
        String temp = getServletRootDir(request) + OsEnvUtils.FILE_SEPARATOR + TEMP_FOLDER;

        File tempdir = new File(temp);
        if (!tempdir.exists() && !tempdir.mkdirs())
        {
            throw new ZuvException("临时目录创建失败 {}", temp);
        }
        return tempdir;
    }

    public static final String TEMP_FOLDER = "tmp";

    //-----------------------------------------------------------------------------------------


}
