/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.utility.SpelUtils:20201203090514
 *
 * SpelUtils.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.utility;

import cc.zuv.collections.ArrayUtils;
import cc.zuv.lang.StringUtils;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.lang.reflect.Method;

/**
 * 解析SPEL 表达式
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2020-12-03 09:05
 * @modify.date     2020-12-03 09:05
 */
public class SpelUtils 
{

    //-----------------------------------------------------------------------------------------

    /**
     * 支持 #p0 参数索引的表达式解析
     * @param rootObject 根对象,method 所在的对象
     * @param spel 表达式
     * @param method 目标方法
     * @param args 方法入参
     * @return 解析后的字符串
     */
    public static String parse(Object rootObject, String spel, Method method, Object[] args)
    {
        if (StringUtils.IsEmpty(spel))
        {
            return "";
        }

        //获取被拦截方法参数名列表(使用Spring支持类库)
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = u.getParameterNames(method);
        if (ArrayUtils.IsEmpty(paraNameArr))
        {
            return spel;
        }

        //使用SPEL进行key的解析
        ExpressionParser parser = new SpelExpressionParser();
        //SPEL上下文
        StandardEvaluationContext context = new MethodBasedEvaluationContext(rootObject,method,args,u);
        //把方法参数放入SPEL上下文中
        for (int i = 0; i < paraNameArr.length; i++)
        {
            context.setVariable(paraNameArr[i], args[i]);
        }

        return parser.parseExpression(spel).getValue(context, String.class);
    }

    //-----------------------------------------------------------------------------------------

}
