/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.validator.AssertUtil:20181225110811
 *
 * AssertUtil.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */
package cc.zuv.web.support.validator;

import cc.zuv.web.support.IWebERRCode;
import cc.zuv.web.support.exception.RestBadRequestException;
import cc.zuv.web.support.exception.RestException;
import cc.zuv.web.support.exception.RestHasExistsException;
import cc.zuv.web.support.exception.RestNotFoundException;
import lombok.extern.slf4j.Slf4j;

import java.util.Collection;
import java.util.Map;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
public class AssertUtil
{

    //-----------------------------------------------------------------------------------------

    public static void assertTrue(boolean value, String message)
    {
        if (value)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotBetween(byte min, byte max, byte value, String message)
    {
        if (value<min || value>=max)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotBetween(int min, int max, int value, String message)
    {
        if (value<min || value>=max)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotBetween(long min, long max, long value, String message)
    {
        if (value<min || value>=max)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(String value, String message)
    {
        if (value==null || value.trim().length()==0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(Object[] array, String message)
    {
        if (array == null || array.length == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(Collection collection, String message)
    {
        if (collection == null || collection.size() == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertEmpty(Map map, String message)
    {
        if (map == null || map.size() == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Long value, String message)
    {
        if (value == null || value == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Integer value, String message)
    {
        if (value == null || value == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Short value, String message)
    {
        if (value == null || value == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertZero(Byte value, String message)
    {
        if (value == null || value == 0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNull(Object value, String message)
    {
        if (value == null)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotFound(Object value, String message)
    {
        if (value == null)
        {
            throw new RestNotFoundException(message);
        }
    }

    public static void assertHasExist(Object value, String message)
    {
        if (value != null)
        {
            throw new RestHasExistsException(message);
        }
    }

    public static void assertNotFound(boolean found, String message)
    {
        if (!found)
        {
            throw new RestNotFoundException(message);
        }
    }

    public static void assertHasExist(boolean exist, String message)
    {
        if (exist)
        {
            throw new RestHasExistsException(message);
        }
    }

    //-----------------------------------------------------------------------------------------

    public static void assertError(IWebERRCode errcode)
    {
        throw new RestException(errcode);
    }

    public static void assertError(IWebERRCode errcode, String message, Object... params)
    {
        throw new RestException(errcode, message, params); //message为null, 则从i18n的resource读取
    }

    public static void assertError(boolean value, IWebERRCode errcode)
    {
        if(value)
            throw new RestException(errcode);
    }

    public static void assertError(boolean value, IWebERRCode errcode, String message, Object... params)
    {
        if(value)
            throw new RestException(errcode, message, params); //message为null, 则从i18n的resource读取
    }

    //-----------------------------------------------------------------------------------------

}
