/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.validator.ValidateUtil:20181225110811
 *
 * ValidateUtil.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.validator;

import cc.zuv.web.support.exception.RestBadRequestException;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Set;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
public class ValidateUtil
{

    //-----------------------------------------------------------------------------------------

    private static Validator validator;

    static
    {
        validator = Validation.buildDefaultValidatorFactory().getValidator();
    }

    //-----------------------------------------------------------------------------------------

    /**
     * 校验对象
     * @param object            待校验对象
     * @param groups            待校验的组
     * @throws RestBadRequestException    校验不通过,则报异常
     */
    public static void validateEntity(Object object, Class<?>... groups)
        throws RestBadRequestException
    {
        Set<ConstraintViolation<Object>> constraintViolations = validator.validate(object, groups);
        if (!constraintViolations.isEmpty())
        {
            StringBuilder msg = new StringBuilder();
            for(ConstraintViolation<Object> constraint:  constraintViolations)
            {
                msg.append(constraint.getMessage()).append(",");
            }
            if(msg.length()>0) msg.deleteCharAt(msg.length()-1);

            throw new RestBadRequestException( msg.toString() );
        }
    }

    //-----------------------------------------------------------------------------------------

}
