/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.validator.impl.OrderValidator:20200801224317
 *
 * OrderValidator.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.validator.impl;

import com.google.common.collect.Lists;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.List;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-07-11 09:11
 * @modify.date     2019-07-11 09:11
 */
public class OrderValidator implements ConstraintValidator<Order, String>
{

    //-----------------------------------------------------------------------------------------

    private List<String> valueList;

    @Override
    public void initialize(Order order)
    {
        valueList = Lists.newArrayList();
        for (String val : order.accepts())
        {
            valueList.add(val.toUpperCase());
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext)
    {
        return value == null || valueList.contains(value.toUpperCase());
    }

    //-----------------------------------------------------------------------------------------

}
