/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.validator.impl.Sort:20200801224317
 *
 * Sort.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.validator.impl;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-07-11 09:12
 * @modify.date     2019-07-11 09:12
 */
@Target({METHOD, FIELD, PARAMETER})
@Retention(RUNTIME)
@Documented
@Constraint(validatedBy = SortValidator.class)
public @interface Sort
{

    String message() default "排序字段不支持";
    String[] accepts() default {"id", "ctime", "mtime"};
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};

}
