/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.webconfig.webcors.WebSpringCorsAdapter:20190717170100
 *
 * WebSpringCorsAdapter.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.webconfig.webcors;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-16 23:41
 * @modify.date     2019-01-16 23:41
 */
@Configuration
@ConditionalOnProperty(name = "zuvboot.webcors.type", havingValue = "spring-adapter")
@Order(Integer.MIN_VALUE)
public class WebSpringCorsAdapter extends WebMvcConfigurerAdapter
{

    //-----------------------------------------------------------------------------------------

    @Override
    public void addCorsMappings(CorsRegistry registry)
    {
        registry.addMapping("/**")
            .allowedOrigins("*")
            .allowedMethods("GET", "POST", "PUT", "DELETE", "OPTIONS")
            .allowCredentials(true)
            .maxAge(3600);
    }

    //-----------------------------------------------------------------------------------------

}
