/*
 * Decompiled with CFR 0.152.
 */
package org.acra.dialog;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.file.BulkReportDeleter;
import org.acra.file.CrashReportPersister;
import org.acra.scheduler.SchedulerStarter;
import org.json.JSONException;

public abstract class BaseCrashReportDialog
extends FragmentActivity {
    private File reportFile;
    private CoreConfiguration config;

    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        this.preInit(savedInstanceState);
        super.onCreate(savedInstanceState);
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "CrashReportDialog extras=" + this.getIntent().getExtras());
        }
        Serializable sConfig = this.getIntent().getSerializableExtra("REPORT_CONFIG");
        Serializable sReportFile = this.getIntent().getSerializableExtra("REPORT_FILE");
        if (sConfig instanceof CoreConfiguration && sReportFile instanceof File) {
            this.config = (CoreConfiguration)sConfig;
            this.reportFile = (File)sReportFile;
            this.init(savedInstanceState);
        } else {
            ACRA.log.w(ACRA.LOG_TAG, "Illegal or incomplete call of BaseCrashReportDialog.");
            this.finish();
        }
    }

    protected void preInit(@Nullable Bundle savedInstanceState) {
    }

    protected void init(@Nullable Bundle savedInstanceState) {
    }

    protected final void cancelReports() {
        new Thread(() -> new BulkReportDeleter((Context)this).deleteReports(false, 0)).start();
    }

    protected final void sendCrash(@Nullable String comment, @Nullable String userEmail) {
        new Thread(() -> {
            CrashReportPersister persister = new CrashReportPersister();
            try {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Add user comment to " + this.reportFile);
                }
                CrashReportData crashData = persister.load(this.reportFile);
                crashData.put(ReportField.USER_COMMENT, comment == null ? "" : comment);
                crashData.put(ReportField.USER_EMAIL, userEmail == null ? "" : userEmail);
                persister.store(crashData, this.reportFile);
            }
            catch (IOException | JSONException e) {
                ACRA.log.w(ACRA.LOG_TAG, "User comment not added: ", e);
            }
            new SchedulerStarter((Context)this, this.config).scheduleReports(this.reportFile, false);
        }).start();
    }

    protected final CoreConfiguration getConfig() {
        return this.config;
    }
}

