/*
 * Decompiled with CFR 0.152.
 */
package org.acra.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.DialogConfiguration;
import org.acra.dialog.CrashReportDialogHelper;
import org.acra.prefs.SharedPreferencesFactory;

public class CrashReportDialog
extends Activity
implements DialogInterface.OnClickListener {
    private static final String STATE_EMAIL = "email";
    private static final String STATE_COMMENT = "comment";
    private static final int PADDING = 10;
    private LinearLayout scrollable;
    private EditText userCommentView;
    private EditText userEmailView;
    private SharedPreferencesFactory sharedPreferencesFactory;
    private DialogConfiguration dialogConfiguration;
    private CrashReportDialogHelper helper;
    private AlertDialog mDialog;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.helper = new CrashReportDialogHelper((Context)this, this.getIntent());
            this.scrollable = new LinearLayout((Context)this);
            this.scrollable.setOrientation(1);
            this.sharedPreferencesFactory = new SharedPreferencesFactory(this.getApplicationContext(), this.helper.getConfig());
            this.dialogConfiguration = (DialogConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)this.helper.getConfig(), DialogConfiguration.class);
            int themeResourceId = this.dialogConfiguration.resTheme();
            if (themeResourceId != 0) {
                this.setTheme(themeResourceId);
            }
            this.buildAndShowDialog(savedInstanceState);
        }
        catch (IllegalArgumentException e) {
            this.finish();
        }
    }

    protected void buildAndShowDialog(@Nullable Bundle savedInstanceState) {
        int iconResourceId;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        String title = this.dialogConfiguration.title();
        if (title != null) {
            dialogBuilder.setTitle((CharSequence)title);
        }
        if ((iconResourceId = this.dialogConfiguration.resIcon()) != 0) {
            dialogBuilder.setIcon(iconResourceId);
        }
        dialogBuilder.setView(this.buildCustomView(savedInstanceState)).setPositiveButton((CharSequence)this.dialogConfiguration.positiveButtonText(), (DialogInterface.OnClickListener)this).setNegativeButton((CharSequence)this.dialogConfiguration.negativeButtonText(), (DialogInterface.OnClickListener)this);
        this.mDialog = dialogBuilder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.show();
    }

    @NonNull
    protected View buildCustomView(@Nullable Bundle savedInstanceState) {
        View email;
        ScrollView root = new ScrollView((Context)this);
        root.setPadding(10, 10, 10, 10);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        root.setFocusable(true);
        root.setFocusableInTouchMode(true);
        root.addView((View)this.scrollable);
        this.addViewToDialog(this.getMainView());
        View comment = this.getCommentLabel();
        if (comment != null) {
            comment.setPadding(comment.getPaddingLeft(), 10, comment.getPaddingRight(), comment.getPaddingBottom());
            this.addViewToDialog(comment);
            String savedComment = null;
            if (savedInstanceState != null) {
                savedComment = savedInstanceState.getString(STATE_COMMENT);
            }
            this.userCommentView = this.getCommentPrompt(savedComment);
            this.addViewToDialog((View)this.userCommentView);
        }
        if ((email = this.getEmailLabel()) != null) {
            email.setPadding(email.getPaddingLeft(), 10, email.getPaddingRight(), email.getPaddingBottom());
            this.addViewToDialog(email);
            String savedEmail = null;
            if (savedInstanceState != null) {
                savedEmail = savedInstanceState.getString(STATE_EMAIL);
            }
            this.userEmailView = this.getEmailPrompt(savedEmail);
            this.addViewToDialog((View)this.userEmailView);
        }
        return root;
    }

    protected final void addViewToDialog(@NonNull View v) {
        this.scrollable.addView(v);
    }

    @NonNull
    protected View getMainView() {
        TextView text = new TextView((Context)this);
        String dialogText = this.dialogConfiguration.text();
        if (dialogText != null) {
            text.setText((CharSequence)dialogText);
        }
        return text;
    }

    @Nullable
    protected View getCommentLabel() {
        String commentPrompt = this.dialogConfiguration.commentPrompt();
        if (commentPrompt != null) {
            TextView labelView = new TextView((Context)this);
            labelView.setText((CharSequence)commentPrompt);
            return labelView;
        }
        return null;
    }

    @NonNull
    protected EditText getCommentPrompt(@Nullable CharSequence savedComment) {
        EditText userCommentView = new EditText((Context)this);
        userCommentView.setLines(2);
        if (savedComment != null) {
            userCommentView.setText(savedComment);
        }
        return userCommentView;
    }

    @Nullable
    protected View getEmailLabel() {
        String emailPrompt = this.dialogConfiguration.emailPrompt();
        if (emailPrompt != null) {
            TextView labelView = new TextView((Context)this);
            labelView.setText((CharSequence)emailPrompt);
            return labelView;
        }
        return null;
    }

    @NonNull
    protected EditText getEmailPrompt(@Nullable CharSequence savedEmail) {
        EditText userEmailView = new EditText((Context)this);
        userEmailView.setSingleLine();
        userEmailView.setInputType(33);
        if (savedEmail != null) {
            userEmailView.setText(savedEmail);
        } else {
            SharedPreferences prefs = this.sharedPreferencesFactory.create();
            userEmailView.setText((CharSequence)prefs.getString("acra.user.email", ""));
        }
        return userEmailView;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            String userEmail;
            String comment = this.userCommentView != null ? this.userCommentView.getText().toString() : "";
            SharedPreferences prefs = this.sharedPreferencesFactory.create();
            if (this.userEmailView != null) {
                userEmail = this.userEmailView.getText().toString();
                prefs.edit().putString("acra.user.email", userEmail).apply();
            } else {
                userEmail = prefs.getString("acra.user.email", "");
            }
            this.helper.sendCrash(comment, userEmail);
        } else {
            this.helper.cancelReports();
        }
        this.finish();
    }

    @CallSuper
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.userCommentView != null && this.userCommentView.getText() != null) {
            outState.putString(STATE_COMMENT, this.userCommentView.getText().toString());
        }
        if (this.userEmailView != null && this.userEmailView.getText() != null) {
            outState.putString(STATE_EMAIL, this.userEmailView.getText().toString());
        }
    }

    protected AlertDialog getDialog() {
        return this.mDialog;
    }
}

