/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.attachment.AcraContentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lorg/acra/util/UriUtils;", "", "()V", "copyFromUri", "", "context", "Landroid/content/Context;", "outputStream", "Ljava/io/OutputStream;", "uri", "Landroid/net/Uri;", "getFileNameFromUri", "", "getMimeType", "acra-http_release"})
@SourceDebugExtension(value={"SMAP\nUriUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriUtils.kt\norg/acra/util/UriUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class UriUtils {
    @NotNull
    public static final UriUtils INSTANCE = new UriUtils();

    private UriUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFromUri(@NotNull Context context, @NotNull OutputStream outputStream, @NotNull Uri uri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                long l = ByteStreamsKt.copyTo((InputStream)it, (OutputStream)outputStream, (int)8192);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw new FileNotFoundException("Could not open " + uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getFileNameFromUri(@NotNull Context context, @NotNull Uri uri) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String[] stringArray = new String[]{"_display_name"};
        Cursor cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
        if (cursor != null) {
            try {
                int columnIndex;
                if (cursor.moveToFirst() && (columnIndex = cursor.getColumnIndex("_display_name")) != -1) {
                    String string = cursor.getString(columnIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(columnIndex)");
                    String string2 = string;
                    return string2;
                }
            }
            finally {
                cursor.close();
            }
        }
        throw new FileNotFoundException("Could not resolve filename of " + uri);
    }

    @NotNull
    public final String getMimeType(@NotNull Context context, @NotNull Uri uri) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content") && (string = context.getContentResolver().getType(uri)) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return AcraContentProvider.Companion.guessMimeType(uri);
    }
}

