/*
 * Decompiled with CFR 0.152.
 */
package org.acra.http;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.acra.ACRA;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.HttpSenderConfiguration;
import org.acra.http.HttpRequest;
import org.acra.security.KeyStoreHelper;
import org.acra.sender.HttpSender;
import org.acra.util.IOUtils;

public abstract class BaseHttpRequest<T>
implements HttpRequest<T> {
    private final CoreConfiguration config;
    private final Context context;
    private final HttpSender.Method method;
    private final String login;
    private final String password;
    private final int connectionTimeOut;
    private final int socketTimeOut;
    private final Map<String, String> headers;
    private final HttpSenderConfiguration senderConfiguration;

    public BaseHttpRequest(@NonNull CoreConfiguration config, @NonNull Context context, @NonNull HttpSender.Method method, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers) {
        this.config = config;
        this.context = context;
        this.method = method;
        this.login = login;
        this.password = password;
        this.connectionTimeOut = connectionTimeOut;
        this.socketTimeOut = socketTimeOut;
        this.headers = headers;
        this.senderConfiguration = (HttpSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, HttpSenderConfiguration.class);
    }

    @Override
    public void send(@NonNull URL url, @NonNull T content) throws IOException {
        HttpURLConnection urlConnection = this.createConnection(url);
        if (urlConnection instanceof HttpsURLConnection) {
            try {
                this.configureHttps((HttpsURLConnection)urlConnection);
            }
            catch (GeneralSecurityException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Could not configure SSL for ACRA request to " + url, (Throwable)e);
            }
        }
        this.configureTimeouts(urlConnection, this.connectionTimeOut, this.socketTimeOut);
        this.configureHeaders(urlConnection, this.login, this.password, this.headers, content);
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Sending request to " + url);
            ACRA.log.d(ACRA.LOG_TAG, "Http " + this.method.name() + " content : ");
            ACRA.log.d(ACRA.LOG_TAG, content.toString());
        }
        try {
            this.writeContent(urlConnection, this.method, content);
            this.handleResponse(urlConnection.getResponseCode(), urlConnection.getResponseMessage());
            urlConnection.disconnect();
        }
        catch (SocketTimeoutException e) {
            if (this.senderConfiguration.dropReportsOnTimeout()) {
                Log.w((String)ACRA.LOG_TAG, (String)"Dropped report due to timeout");
            }
            throw e;
        }
    }

    @NonNull
    protected HttpURLConnection createConnection(@NonNull URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected void configureHttps(@NonNull HttpsURLConnection connection) throws GeneralSecurityException {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        KeyStore keyStore = KeyStoreHelper.getKeyStore(this.context, this.config);
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    protected void configureTimeouts(@NonNull HttpURLConnection connection, int connectionTimeOut, int socketTimeOut) {
        connection.setConnectTimeout(connectionTimeOut);
        connection.setReadTimeout(socketTimeOut);
    }

    protected void configureHeaders(@NonNull HttpURLConnection connection, @Nullable String login, @Nullable String password, @Nullable Map<String, String> customHeaders, @NonNull T t) throws IOException {
        connection.setRequestProperty("User-Agent", String.format("Android ACRA %1$s", "5.3.0-rc01"));
        connection.setRequestProperty("Accept", "text/html,application/xml,application/json,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        connection.setRequestProperty("Content-Type", this.getContentType(this.context, t));
        if (login != null && password != null) {
            String credentials = login + ':' + password;
            String encoded = new String(Base64.encode((byte[])credentials.getBytes("UTF-8"), (int)2), "UTF-8");
            connection.setRequestProperty("Authorization", "Basic " + encoded);
        }
        if (this.senderConfiguration.compress()) {
            connection.setRequestProperty("Content-Encoding", "gzip");
        }
        if (customHeaders != null) {
            for (Map.Entry<String, String> header : customHeaders.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    @NonNull
    protected abstract String getContentType(@NonNull Context var1, @NonNull T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContent(@NonNull HttpURLConnection connection, @NonNull HttpSender.Method method, @NonNull T content) throws IOException {
        connection.setRequestMethod(method.name());
        connection.setDoOutput(true);
        System.setProperty("http.keepAlive", "false");
        connection.connect();
        FilterOutputStream outputStream = this.senderConfiguration.compress() ? new GZIPOutputStream(connection.getOutputStream(), 8192) : new BufferedOutputStream(connection.getOutputStream());
        try {
            this.write(outputStream, content);
            ((OutputStream)outputStream).flush();
        }
        finally {
            IOUtils.safeClose((Closeable)outputStream);
        }
    }

    protected abstract void write(OutputStream var1, @NonNull T var2) throws IOException;

    protected void handleResponse(int responseCode, String responseMessage) throws IOException {
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Request response : " + responseCode + " : " + responseMessage);
        }
        if (responseCode >= 200 && responseCode < 300) {
            ACRA.log.i(ACRA.LOG_TAG, "Request received by server");
        } else {
            if (responseCode == 408 || responseCode >= 500) {
                ACRA.log.w(ACRA.LOG_TAG, "Could not send ACRA Post responseCode=" + responseCode + " message=" + responseMessage);
                throw new IOException("Host returned error code " + responseCode);
            }
            if (responseCode >= 400) {
                ACRA.log.w(ACRA.LOG_TAG, responseCode + ": Client error - request will be discarded");
            } else {
                ACRA.log.w(ACRA.LOG_TAG, "Could not send ACRA Post - request will be discarded. responseCode=" + responseCode + " message=" + responseMessage);
            }
        }
    }
}

