/*
 * Decompiled with CFR 0.152.
 */
package org.acra.http;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.acra.config.CoreConfiguration;
import org.acra.http.BaseHttpRequest;
import org.acra.sender.HttpSender;
import org.acra.util.UriUtils;

public class BinaryHttpRequest
extends BaseHttpRequest<Uri> {
    private final Context context;

    public BinaryHttpRequest(@NonNull CoreConfiguration config, @NonNull Context context, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers) {
        super(config, context, HttpSender.Method.PUT, login, password, connectionTimeOut, socketTimeOut, headers);
        this.context = context;
    }

    @Override
    @NonNull
    protected String getContentType(@NonNull Context context, @NonNull Uri uri) {
        return UriUtils.getMimeType(context, uri);
    }

    @Override
    protected void write(OutputStream outputStream, @NonNull Uri content) throws IOException {
        UriUtils.copyFromUri(this.context, outputStream, content);
    }
}

