/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.content.Context;
import android.support.annotation.NonNull;
import java.io.IOException;
import java.io.InputStream;
import org.acra.ACRA;
import org.acra.security.BaseKeyStoreFactory;

final class AssetKeyStoreFactory
extends BaseKeyStoreFactory {
    private final String assetName;

    AssetKeyStoreFactory(String certificateType, String assetName) {
        super(certificateType);
        this.assetName = assetName;
    }

    @Override
    public InputStream getInputStream(@NonNull Context context) {
        try {
            return context.getAssets().open(this.assetName);
        }
        catch (IOException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Could not open certificate in asset://" + this.assetName, (Throwable)e);
            return null;
        }
    }
}

