/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.security.KeyStore;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.HttpSenderConfiguration;
import org.acra.security.AssetKeyStoreFactory;
import org.acra.security.FileKeyStoreFactory;
import org.acra.security.KeyStoreFactory;
import org.acra.security.NoKeyStoreFactory;
import org.acra.security.ResourceKeyStoreFactory;
import org.acra.util.InstanceCreator;

public final class KeyStoreHelper {
    private static final String ASSET_PREFIX = "asset://";

    private KeyStoreHelper() {
    }

    @Nullable
    public static KeyStore getKeyStore(@NonNull Context context, @NonNull CoreConfiguration config) {
        InstanceCreator instanceCreator = new InstanceCreator();
        HttpSenderConfiguration senderConfiguration = (HttpSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, HttpSenderConfiguration.class);
        KeyStore keyStore = ((KeyStoreFactory)instanceCreator.create(senderConfiguration.keyStoreFactoryClass(), NoKeyStoreFactory::new)).create(context);
        if (keyStore == null) {
            int certificateRes = senderConfiguration.resCertificate();
            String certificatePath = senderConfiguration.certificatePath();
            String certificateType = senderConfiguration.certificateType();
            if (certificateRes != 0) {
                keyStore = new ResourceKeyStoreFactory(certificateType, certificateRes).create(context);
            } else if (!certificatePath.equals("")) {
                keyStore = certificatePath.startsWith(ASSET_PREFIX) ? new AssetKeyStoreFactory(certificateType, certificatePath.substring(ASSET_PREFIX.length())).create(context) : new FileKeyStoreFactory(certificateType, certificatePath).create(context);
            }
        }
        return keyStore;
    }
}

