/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.attachment.AttachmentUriProvider;
import org.acra.attachment.DefaultAttachmentProvider;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.HttpSenderConfiguration;
import org.acra.data.CrashReportData;
import org.acra.data.StringFormat;
import org.acra.http.BinaryHttpRequest;
import org.acra.http.DefaultHttpRequest;
import org.acra.http.MultipartHttpRequest;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.InstanceCreator;
import org.acra.util.UriUtils;

public class HttpSender
implements ReportSender {
    private final CoreConfiguration config;
    private final HttpSenderConfiguration httpConfig;
    private final Uri mFormUri;
    private final Method mMethod;
    private final StringFormat mType;
    private String mUsername;
    private String mPassword;

    public HttpSender(@NonNull CoreConfiguration config, @Nullable Method method, @Nullable StringFormat type) {
        this(config, method, type, null);
    }

    public HttpSender(@NonNull CoreConfiguration config, @Nullable Method method, @Nullable StringFormat type, @Nullable String formUri) {
        this.config = config;
        this.httpConfig = (HttpSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, HttpSenderConfiguration.class);
        this.mMethod = method == null ? this.httpConfig.httpMethod() : method;
        this.mFormUri = Uri.parse((String)(formUri == null ? this.httpConfig.uri() : formUri));
        this.mType = type == null ? config.reportFormat() : type;
        this.mUsername = null;
        this.mPassword = null;
    }

    public void setBasicAuth(@Nullable String username, @Nullable String password) {
        this.mUsername = username;
        this.mPassword = password;
    }

    public void send(@NonNull Context context, @NonNull CrashReportData report) throws ReportSenderException {
        try {
            String login;
            String baseUrl = this.mFormUri.toString();
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Connect to " + baseUrl);
            }
            String string = this.mUsername != null ? this.mUsername : (login = this.isNull(this.httpConfig.basicAuthLogin()) ? null : this.httpConfig.basicAuthLogin());
            String password = this.mPassword != null ? this.mPassword : (this.isNull(this.httpConfig.basicAuthPassword()) ? null : this.httpConfig.basicAuthPassword());
            InstanceCreator instanceCreator = new InstanceCreator();
            List uris = ((AttachmentUriProvider)instanceCreator.create(this.config.attachmentUriProvider(), DefaultAttachmentProvider::new)).getAttachments(context, this.config);
            String reportAsString = this.convertToString(report, this.mType);
            URL reportUrl = this.mMethod.createURL(baseUrl, report);
            this.sendHttpRequests(this.config, context, this.mMethod, this.mType.getMatchingHttpContentType(), login, password, this.httpConfig.connectionTimeout(), this.httpConfig.socketTimeout(), (Map<String, String>)this.httpConfig.httpHeaders(), reportAsString, reportUrl, uris);
        }
        catch (Exception e) {
            throw new ReportSenderException("Error while sending " + this.config.reportFormat() + " report via Http " + this.mMethod.name(), (Throwable)e);
        }
    }

    protected void sendHttpRequests(@NonNull CoreConfiguration configuration, @NonNull Context context, @NonNull Method method, @NonNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NonNull String content, @NonNull URL url, @NonNull List<Uri> attachments) throws IOException {
        switch (method) {
            case POST: {
                if (attachments.isEmpty()) {
                    this.sendWithoutAttachments(configuration, context, method, contentType, login, password, connectionTimeOut, socketTimeOut, headers, content, url);
                    break;
                }
                this.postMultipart(configuration, context, contentType, login, password, connectionTimeOut, socketTimeOut, headers, content, url, attachments);
                break;
            }
            case PUT: {
                this.sendWithoutAttachments(configuration, context, method, contentType, login, password, connectionTimeOut, socketTimeOut, headers, content, url);
                for (Uri uri : attachments) {
                    this.putAttachment(configuration, context, login, password, connectionTimeOut, socketTimeOut, headers, url, uri);
                }
                break;
            }
        }
    }

    protected void sendWithoutAttachments(@NonNull CoreConfiguration configuration, @NonNull Context context, @NonNull Method method, @NonNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NonNull String content, @NonNull URL url) throws IOException {
        new DefaultHttpRequest(configuration, context, method, contentType, login, password, connectionTimeOut, socketTimeOut, headers).send(url, content);
    }

    protected void postMultipart(@NonNull CoreConfiguration configuration, @NonNull Context context, @NonNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NonNull String content, @NonNull URL url, @NonNull List<Uri> attachments) throws IOException {
        new MultipartHttpRequest(configuration, context, contentType, login, password, connectionTimeOut, socketTimeOut, headers).send(url, Pair.create((Object)content, attachments));
    }

    protected void putAttachment(@NonNull CoreConfiguration configuration, @NonNull Context context, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NonNull URL url, @NonNull Uri attachment) throws IOException {
        try {
            URL attachmentUrl = new URL(url.toString() + "-" + UriUtils.getFileNameFromUri(context, attachment));
            new BinaryHttpRequest(configuration, context, login, password, connectionTimeOut, socketTimeOut, headers).send(attachmentUrl, attachment);
        }
        catch (FileNotFoundException e) {
            ACRA.log.w("Not sending attachment", (Throwable)e);
        }
    }

    @NonNull
    protected String convertToString(CrashReportData report, @NonNull StringFormat format) throws Exception {
        return format.toFormattedString(report, this.config.reportContent(), "&", "\n", true);
    }

    private boolean isNull(@Nullable String aString) {
        return aString == null || "ACRA-NULL-STRING".equals(aString);
    }

    public static enum Method {
        POST{

            @Override
            @NonNull
            URL createURL(@NonNull String baseUrl, @NonNull CrashReportData report) throws MalformedURLException {
                return new URL(baseUrl);
            }
        }
        ,
        PUT{

            @Override
            @NonNull
            URL createURL(@NonNull String baseUrl, @NonNull CrashReportData report) throws MalformedURLException {
                return new URL(baseUrl + '/' + report.getString(ReportField.REPORT_ID));
            }
        };


        @NonNull
        abstract URL createURL(@NonNull String var1, @NonNull CrashReportData var2) throws MalformedURLException;
    }
}

