/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.acra.ACRA;
import org.acra.security.KeyStoreFactory;
import org.acra.util.IOUtils;

public abstract class BaseKeyStoreFactory
implements KeyStoreFactory {
    private final String certificateType;

    public BaseKeyStoreFactory() {
        this("X.509");
    }

    public BaseKeyStoreFactory(String certificateType) {
        this.certificateType = certificateType;
    }

    @Nullable
    protected abstract InputStream getInputStream(@NonNull Context var1);

    protected String getKeyStoreType() {
        return KeyStore.getDefaultType();
    }

    @NonNull
    protected Type getStreamType() {
        return Type.CERTIFICATE;
    }

    @Nullable
    protected char[] getPassword() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final KeyStore create(@NonNull Context context) {
        InputStream inputStream = this.getInputStream(context);
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                KeyStore keyStore = KeyStore.getInstance(this.getKeyStoreType());
                switch (this.getStreamType()) {
                    case CERTIFICATE: {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance(this.certificateType);
                        Certificate certificate = certificateFactory.generateCertificate(bufferedInputStream);
                        keyStore.load(null, null);
                        keyStore.setCertificateEntry("ca", certificate);
                        break;
                    }
                    case KEYSTORE: {
                        keyStore.load(bufferedInputStream, this.getPassword());
                    }
                }
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Could not load certificate", (Throwable)e);
            }
            catch (KeyStoreException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Could not load keystore", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Could not load keystore", (Throwable)e);
            }
            catch (IOException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Could not load keystore", (Throwable)e);
            }
            finally {
                IOUtils.safeClose((Closeable)bufferedInputStream);
            }
        }
        return null;
    }

    public static enum Type {
        CERTIFICATE,
        KEYSTORE;

    }
}

