/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import androidx.annotation.NonNull;
import androidx.annotation.RawRes;
import java.io.Serializable;
import org.acra.collections.ImmutableMap;
import org.acra.config.Configuration;
import org.acra.config.HttpSenderConfigurationBuilderImpl;
import org.acra.security.KeyStoreFactory;
import org.acra.sender.HttpSender;

public final class HttpSenderConfiguration
implements Serializable,
Configuration {
    private final boolean enabled;
    @NonNull
    private final String uri;
    @NonNull
    private final String basicAuthLogin;
    @NonNull
    private final String basicAuthPassword;
    @NonNull
    private final HttpSender.Method httpMethod;
    private final int connectionTimeout;
    private final int socketTimeout;
    private final boolean dropReportsOnTimeout;
    @NonNull
    private final Class<? extends KeyStoreFactory> keyStoreFactoryClass;
    @NonNull
    private final String certificatePath;
    @RawRes
    private final int resCertificate;
    @NonNull
    private final String certificateType;
    private final boolean compress;
    @NonNull
    private final ImmutableMap<String, String> httpHeaders;

    public HttpSenderConfiguration(@NonNull HttpSenderConfigurationBuilderImpl arg0) {
        this.enabled = arg0.enabled();
        this.uri = arg0.uri();
        this.basicAuthLogin = arg0.basicAuthLogin();
        this.basicAuthPassword = arg0.basicAuthPassword();
        this.httpMethod = arg0.httpMethod();
        this.connectionTimeout = arg0.connectionTimeout();
        this.socketTimeout = arg0.socketTimeout();
        this.dropReportsOnTimeout = arg0.dropReportsOnTimeout();
        this.keyStoreFactoryClass = arg0.keyStoreFactoryClass();
        this.certificatePath = arg0.certificatePath();
        this.resCertificate = arg0.resCertificate();
        this.certificateType = arg0.certificateType();
        this.compress = arg0.compress();
        this.httpHeaders = new ImmutableMap(arg0.httpHeaders());
    }

    public boolean enabled() {
        return this.enabled;
    }

    @NonNull
    public String uri() {
        return this.uri;
    }

    @NonNull
    public String basicAuthLogin() {
        return this.basicAuthLogin;
    }

    @NonNull
    public String basicAuthPassword() {
        return this.basicAuthPassword;
    }

    @NonNull
    public HttpSender.Method httpMethod() {
        return this.httpMethod;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public boolean dropReportsOnTimeout() {
        return this.dropReportsOnTimeout;
    }

    @NonNull
    public Class<? extends KeyStoreFactory> keyStoreFactoryClass() {
        return this.keyStoreFactoryClass;
    }

    @NonNull
    public String certificatePath() {
        return this.certificatePath;
    }

    @RawRes
    public int resCertificate() {
        return this.resCertificate;
    }

    @NonNull
    public String certificateType() {
        return this.certificateType;
    }

    public boolean compress() {
        return this.compress;
    }

    @NonNull
    public ImmutableMap<String, String> httpHeaders() {
        return this.httpHeaders;
    }
}

