/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.acra.attachment.AcraContentProvider;

public final class UriUtils {
    private UriUtils() {
    }

    public static void copyFromUri(@NonNull Context context, @NonNull OutputStream outputStream, @NonNull Uri uri) throws IOException {
        try (InputStream inputStream = context.getContentResolver().openInputStream(uri);){
            int length;
            if (inputStream == null) {
                throw new FileNotFoundException("Could not open " + uri.toString());
            }
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
        }
    }

    @NonNull
    public static String getFileNameFromUri(@NonNull Context context, @NonNull Uri uri) throws FileNotFoundException {
        try (Cursor cursor = context.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null);){
            if (cursor != null && cursor.moveToFirst()) {
                String string = cursor.getString(cursor.getColumnIndex("_display_name"));
                return string;
            }
        }
        throw new FileNotFoundException("Could not resolve filename of " + uri);
    }

    @NonNull
    public static String getMimeType(@NonNull Context context, @NonNull Uri uri) {
        ContentResolver contentResolver;
        String type;
        if (uri.getScheme().equals("content") && (type = (contentResolver = context.getContentResolver()).getType(uri)) != null) {
            return type;
        }
        return AcraContentProvider.guessMimeType((Uri)uri);
    }
}

