/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import androidx.annotation.RawRes;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.annotation.AcraHttpSender;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.BaseHttpConfigurationBuilder;
import org.acra.config.ConfigurationBuilder;
import org.acra.config.HttpSenderConfiguration;
import org.acra.security.KeyStoreFactory;
import org.acra.security.NoKeyStoreFactory;
import org.acra.security.TLS;
import org.acra.sender.HttpSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010N\u001a\u00020OH\u0016J\u0014\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060QH\u0007J\u001a\u0010R\u001a\u00020\u00002\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060QJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0015J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0015J\u000e\u0010\\\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u0016\u0010]\u001a\u00020\u00002\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020807J\u0010\u0010^\u001a\u00020\u00002\b\b\u0001\u0010=\u001a\u00020\u001bJ\u000e\u0010_\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u001bJ\u001f\u0010`\u001a\u00020\u00002\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020E0D\"\u00020E\u00a2\u0006\u0002\u0010aJ\u000e\u0010b\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\u0004R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0017\"\u0004\b,\u0010\u0019R\u001a\u0010-\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0017\"\u0004\b/\u0010\u0019R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\"\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020807X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001e\u0010=\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001d\"\u0004\b?\u0010\u001fR\u001a\u0010@\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001d\"\u0004\bB\u0010\u001fR$\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020E0DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010J\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010K\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\b\"\u0004\bM\u0010\n\u00a8\u0006c"}, d2={"Lorg/acra/config/HttpSenderConfigurationBuilder;", "Lorg/acra/config/ConfigurationBuilder;", "arg0", "Landroid/content/Context;", "(Landroid/content/Context;)V", "basicAuthLogin", "", "getBasicAuthLogin", "()Ljava/lang/String;", "setBasicAuthLogin", "(Ljava/lang/String;)V", "basicAuthPassword", "getBasicAuthPassword", "setBasicAuthPassword", "certificatePath", "getCertificatePath", "setCertificatePath", "certificateType", "getCertificateType", "setCertificateType", "compress", "", "getCompress", "()Z", "setCompress", "(Z)V", "connectionTimeout", "", "getConnectionTimeout", "()I", "setConnectionTimeout", "(I)V", "context", "getContext", "()Landroid/content/Context;", "setContext", "delegate", "Lorg/acra/config/BaseHttpConfigurationBuilder;", "getDelegate", "()Lorg/acra/config/BaseHttpConfigurationBuilder;", "setDelegate", "(Lorg/acra/config/BaseHttpConfigurationBuilder;)V", "dropReportsOnTimeout", "getDropReportsOnTimeout", "setDropReportsOnTimeout", "enabled", "getEnabled", "setEnabled", "httpMethod", "Lorg/acra/sender/HttpSender$Method;", "getHttpMethod", "()Lorg/acra/sender/HttpSender$Method;", "setHttpMethod", "(Lorg/acra/sender/HttpSender$Method;)V", "keyStoreFactoryClass", "Ljava/lang/Class;", "Lorg/acra/security/KeyStoreFactory;", "getKeyStoreFactoryClass", "()Ljava/lang/Class;", "setKeyStoreFactoryClass", "(Ljava/lang/Class;)V", "resCertificate", "getResCertificate", "setResCertificate", "socketTimeout", "getSocketTimeout", "setSocketTimeout", "tlsProtocols", "", "Lorg/acra/security/TLS;", "getTlsProtocols", "()[Lorg/acra/security/TLS;", "setTlsProtocols", "([Lorg/acra/security/TLS;)V", "[Lorg/acra/security/TLS;", "uri", "getUri", "setUri", "build", "Lorg/acra/config/HttpSenderConfiguration;", "httpHeaders", "", "setHttpHeaders", "headers", "withBasicAuthLogin", "withBasicAuthPassword", "withCertificatePath", "withCertificateType", "withCompress", "withConnectionTimeout", "withDropReportsOnTimeout", "withEnabled", "withHttpMethod", "withKeyStoreFactoryClass", "withResCertificate", "withSocketTimeout", "withTlsProtocols", "([Lorg/acra/security/TLS;)Lorg/acra/config/HttpSenderConfigurationBuilder;", "withUri", "acra-http_release"})
public final class HttpSenderConfigurationBuilder
implements ConfigurationBuilder {
    @NotNull
    private Context context;
    private boolean enabled;
    @NotNull
    private String uri;
    @NotNull
    private String basicAuthLogin;
    @NotNull
    private String basicAuthPassword;
    @NotNull
    private HttpSender.Method httpMethod;
    private int connectionTimeout;
    private int socketTimeout;
    private boolean dropReportsOnTimeout;
    @NotNull
    private Class<? extends KeyStoreFactory> keyStoreFactoryClass;
    @NotNull
    private String certificatePath;
    @RawRes
    private int resCertificate;
    @NotNull
    private String certificateType;
    private boolean compress;
    @NotNull
    private TLS[] tlsProtocols;
    @NotNull
    private BaseHttpConfigurationBuilder delegate;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    public final void setUri(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.uri = string;
    }

    @NotNull
    public final String getBasicAuthLogin() {
        return this.basicAuthLogin;
    }

    public final void setBasicAuthLogin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.basicAuthLogin = string;
    }

    @NotNull
    public final String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public final void setBasicAuthPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.basicAuthPassword = string;
    }

    @NotNull
    public final HttpSender.Method getHttpMethod() {
        return this.httpMethod;
    }

    public final void setHttpMethod(@NotNull HttpSender.Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"<set-?>");
        this.httpMethod = method;
    }

    public final int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public final int getSocketTimeout() {
        return this.socketTimeout;
    }

    public final void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public final boolean getDropReportsOnTimeout() {
        return this.dropReportsOnTimeout;
    }

    public final void setDropReportsOnTimeout(boolean bl) {
        this.dropReportsOnTimeout = bl;
    }

    @NotNull
    public final Class<? extends KeyStoreFactory> getKeyStoreFactoryClass() {
        return this.keyStoreFactoryClass;
    }

    public final void setKeyStoreFactoryClass(@NotNull Class<? extends KeyStoreFactory> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
        this.keyStoreFactoryClass = clazz;
    }

    @NotNull
    public final String getCertificatePath() {
        return this.certificatePath;
    }

    public final void setCertificatePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.certificatePath = string;
    }

    public final int getResCertificate() {
        return this.resCertificate;
    }

    public final void setResCertificate(int n) {
        this.resCertificate = n;
    }

    @NotNull
    public final String getCertificateType() {
        return this.certificateType;
    }

    public final void setCertificateType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.certificateType = string;
    }

    public final boolean getCompress() {
        return this.compress;
    }

    public final void setCompress(boolean bl) {
        this.compress = bl;
    }

    @NotNull
    public final TLS[] getTlsProtocols() {
        return this.tlsProtocols;
    }

    public final void setTlsProtocols(@NotNull TLS[] tLSArray) {
        Intrinsics.checkNotNullParameter((Object)tLSArray, (String)"<set-?>");
        this.tlsProtocols = tLSArray;
    }

    @NotNull
    public final BaseHttpConfigurationBuilder getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(@NotNull BaseHttpConfigurationBuilder baseHttpConfigurationBuilder) {
        Intrinsics.checkNotNullParameter((Object)baseHttpConfigurationBuilder, (String)"<set-?>");
        this.delegate = baseHttpConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withEnabled(boolean enabled) {
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.enabled = enabled;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.uri = uri;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withBasicAuthLogin(@NotNull String basicAuthLogin) {
        Intrinsics.checkNotNullParameter((Object)basicAuthLogin, (String)"basicAuthLogin");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.basicAuthLogin = basicAuthLogin;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withBasicAuthPassword(@NotNull String basicAuthPassword) {
        Intrinsics.checkNotNullParameter((Object)basicAuthPassword, (String)"basicAuthPassword");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.basicAuthPassword = basicAuthPassword;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withHttpMethod(@NotNull HttpSender.Method httpMethod) {
        Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.httpMethod = httpMethod;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withConnectionTimeout(int connectionTimeout) {
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.connectionTimeout = connectionTimeout;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withSocketTimeout(int socketTimeout) {
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.socketTimeout = socketTimeout;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withDropReportsOnTimeout(boolean dropReportsOnTimeout) {
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.dropReportsOnTimeout = dropReportsOnTimeout;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withKeyStoreFactoryClass(@NotNull Class<? extends KeyStoreFactory> keyStoreFactoryClass) {
        Intrinsics.checkNotNullParameter(keyStoreFactoryClass, (String)"keyStoreFactoryClass");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.keyStoreFactoryClass = keyStoreFactoryClass;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withCertificatePath(@NotNull String certificatePath) {
        Intrinsics.checkNotNullParameter((Object)certificatePath, (String)"certificatePath");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.certificatePath = certificatePath;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withResCertificate(@RawRes int resCertificate) {
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.resCertificate = resCertificate;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withCertificateType(@NotNull String certificateType) {
        Intrinsics.checkNotNullParameter((Object)certificateType, (String)"certificateType");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.certificateType = certificateType;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withCompress(boolean compress) {
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.compress = compress;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder withTlsProtocols(TLS ... tlsProtocols) {
        Intrinsics.checkNotNullParameter((Object)tlsProtocols, (String)"tlsProtocols");
        HttpSenderConfigurationBuilder httpSenderConfigurationBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpSenderConfigurationBuilder $this$apply = httpSenderConfigurationBuilder;
        boolean bl3 = false;
        $this$apply.tlsProtocols = tlsProtocols;
        return httpSenderConfigurationBuilder;
    }

    @NotNull
    public final HttpSenderConfigurationBuilder setHttpHeaders(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.delegate.setHttpHeaders(headers);
        return this;
    }

    @NotNull
    public final Map<String, String> httpHeaders() {
        return this.delegate.httpHeaders();
    }

    @NotNull
    public HttpSenderConfiguration build() throws ACRAConfigurationException {
        if (this.enabled && Intrinsics.areEqual((Object)this.uri, (Object)"ACRA-NULL-STRING")) {
            throw (Throwable)new ACRAConfigurationException("One of uri must not be default");
        }
        return new HttpSenderConfiguration(this);
    }

    public HttpSenderConfigurationBuilder(@NotNull Context arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        TLS[] annotation = arg0.getClass().getAnnotation(AcraHttpSender.class);
        this.context = arg0;
        this.enabled = annotation != null;
        Object object = annotation;
        if (annotation == null || (object = object.uri()) == null) {
            object = "ACRA-NULL-STRING";
        }
        this.uri = object;
        Object object2 = annotation;
        if (annotation == null || (object2 = object2.basicAuthLogin()) == null) {
            object2 = "ACRA-NULL-STRING";
        }
        this.basicAuthLogin = object2;
        Object object3 = annotation;
        if (annotation == null || (object3 = object3.basicAuthPassword()) == null) {
            object3 = "ACRA-NULL-STRING";
        }
        this.basicAuthPassword = object3;
        Object object4 = annotation;
        if (annotation == null || (object4 = object4.httpMethod()) == null) {
            object4 = HttpSender.Method.POST;
        }
        this.httpMethod = object4;
        this.connectionTimeout = annotation != null ? annotation.connectionTimeout() : 5000;
        this.socketTimeout = annotation != null ? annotation.socketTimeout() : 20000;
        this.dropReportsOnTimeout = annotation != null ? annotation.dropReportsOnTimeout() : false;
        Class<NoKeyStoreFactory> clazz = annotation;
        if (annotation == null || (clazz = clazz.keyStoreFactoryClass()) == null) {
            clazz = NoKeyStoreFactory.class;
        }
        this.keyStoreFactoryClass = clazz;
        Object object5 = annotation;
        if (annotation == null || (object5 = object5.certificatePath()) == null) {
            object5 = "";
        }
        this.certificatePath = object5;
        this.resCertificate = annotation != null ? annotation.resCertificate() : 0;
        Object object6 = annotation;
        if (annotation == null || (object6 = object6.certificateType()) == null) {
            object6 = "X.509";
        }
        this.certificateType = object6;
        this.compress = annotation != null ? annotation.compress() : false;
        TLS[] tLSArray = annotation;
        if (annotation == null || (tLSArray = tLSArray.tlsProtocols()) == null) {
            TLS[] tLSArray2 = new TLS[4];
            tLSArray2[0] = TLS.V1_3;
            tLSArray2[1] = TLS.V1_2;
            tLSArray2[2] = TLS.V1_1;
            tLSArray = tLSArray2;
            tLSArray2[3] = TLS.V1;
        }
        this.tlsProtocols = tLSArray;
        this.delegate = new BaseHttpConfigurationBuilder();
    }
}

