/*
 * Decompiled with CFR 0.152.
 */
package org.acra.http;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import org.acra.ACRA;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.HttpSenderConfiguration;
import org.acra.http.HttpRequest;
import org.acra.log.ACRALog;
import org.acra.security.KeyStoreHelper;
import org.acra.security.ProtocolSocketFactoryWrapper;
import org.acra.sender.HttpSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011JG\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0004J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0004J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0004J\u001d\u0010!\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\nH\u0004J\u001d\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010,J%\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010'\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/acra/http/BaseHttpRequest;", "T", "Lorg/acra/http/HttpRequest;", "config", "Lorg/acra/config/CoreConfiguration;", "context", "Landroid/content/Context;", "method", "Lorg/acra/sender/HttpSender$Method;", "login", "", "password", "connectionTimeOut", "", "socketTimeOut", "headers", "", "(Lorg/acra/config/CoreConfiguration;Landroid/content/Context;Lorg/acra/sender/HttpSender$Method;Ljava/lang/String;Ljava/lang/String;IILjava/util/Map;)V", "senderConfiguration", "Lorg/acra/config/HttpSenderConfiguration;", "configureHeaders", "", "connection", "Ljava/net/HttpURLConnection;", "customHeaders", "t", "(Ljava/net/HttpURLConnection;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Object;)V", "configureHttps", "Ljavax/net/ssl/HttpsURLConnection;", "configureTimeouts", "createConnection", "url", "Ljava/net/URL;", "getContentType", "(Landroid/content/Context;Ljava/lang/Object;)Ljava/lang/String;", "handleResponse", "responseCode", "responseMessage", "send", "content", "(Ljava/net/URL;Ljava/lang/Object;)V", "write", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;Ljava/lang/Object;)V", "writeContent", "(Ljava/net/HttpURLConnection;Lorg/acra/sender/HttpSender$Method;Ljava/lang/Object;)V", "acra-http_release"})
public abstract class BaseHttpRequest<T>
implements HttpRequest<T> {
    private final HttpSenderConfiguration senderConfiguration;
    private final CoreConfiguration config;
    private final Context context;
    private final HttpSender.Method method;
    private final String login;
    private final String password;
    private final int connectionTimeOut;
    private final int socketTimeOut;
    private final Map<String, String> headers;

    @Override
    public void send(@NotNull URL url, T content) throws IOException {
        String string;
        ACRALog aCRALog;
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpURLConnection urlConnection = this.createConnection(url);
        if (urlConnection instanceof HttpsURLConnection) {
            try {
                this.configureHttps((HttpsURLConnection)urlConnection);
            }
            catch (GeneralSecurityException e) {
                boolean $i$f$error = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Could not configure SSL for ACRA request to " + url;
                aCRALog.e(string2, string, (Throwable)e);
            }
        }
        this.configureTimeouts(urlConnection, this.connectionTimeOut, this.socketTimeOut);
        this.configureHeaders(urlConnection, this.login, this.password, this.headers, content);
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Sending request to " + url;
            aCRALog.d(string2, string);
        }
        $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Http " + this.method.name() + " content : ";
            aCRALog.d(string2, string);
        }
        $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = String.valueOf(content);
            aCRALog.d(string2, string);
        }
        try {
            this.writeContent(urlConnection, this.method, content);
            int n = urlConnection.getResponseCode();
            String string3 = urlConnection.getResponseMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"urlConnection.responseMessage");
            this.handleResponse(n, string3);
            urlConnection.disconnect();
        }
        catch (SocketTimeoutException e) {
            if (this.senderConfiguration.getDropReportsOnTimeout()) {
                Log.w((String)ACRA.LOG_TAG, (String)"Dropped report due to timeout");
            }
            throw (Throwable)e;
        }
    }

    @NotNull
    protected final HttpURLConnection createConnection(@NotNull URL url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        return (HttpURLConnection)uRLConnection;
    }

    protected final void configureHttps(@NotNull HttpsURLConnection connection) throws GeneralSecurityException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore2 = KeyStoreHelper.INSTANCE.getKeyStore(this.context, this.config);
        tmf.init(keyStore2);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = tmf;
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerFactory, (String)"tmf");
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        SSLContext sSLContext = sslContext;
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"sslContext");
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
        connection.setSSLSocketFactory(new ProtocolSocketFactoryWrapper(sSLSocketFactory, ArraysKt.asList((Object[])this.senderConfiguration.getTlsProtocols())));
    }

    protected final void configureTimeouts(@NotNull HttpURLConnection connection, int connectionTimeOut, int socketTimeOut) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.setConnectTimeout(connectionTimeOut);
        connection.setReadTimeout(socketTimeOut);
    }

    /*
     * WARNING - void declaration
     */
    protected final void configureHeaders(@NotNull HttpURLConnection connection, @Nullable String login, @Nullable String password, @Nullable Map<String, String> customHeaders, T t) throws IOException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object object = "Android ACRA %1$s";
        Object object2 = new Object[]{"5.8.1-beta11"};
        boolean bl = false;
        String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        connection.setRequestProperty("User-Agent", string);
        connection.setRequestProperty("Accept", "text/html,application/xml,application/json,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        connection.setRequestProperty("Content-Type", this.getContentType(this.context, t));
        if (login != null && password != null) {
            object = login + ':' + password;
            object2 = Charsets.UTF_8;
            bl = false;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)object2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = Base64.encode((byte[])byArray, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Base64.encode(\"$login:$p\u2026s.UTF_8), Base64.NO_WRAP)");
            object = byArray2;
            object2 = Charsets.UTF_8;
            bl = false;
            String encoded = new String((byte[])object, (Charset)object2);
            connection.setRequestProperty("Authorization", "Basic " + encoded);
        }
        if (this.senderConfiguration.getCompress()) {
            connection.setRequestProperty("Content-Encoding", "gzip");
        }
        Map<String, String> map = customHeaders;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv;
            bl = false;
            Iterator iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl3 = false;
                String string3 = (String)entry.getKey();
                entry = $dstr$key$value;
                bl3 = false;
                String value = (String)entry.getValue();
                connection.setRequestProperty((String)key, value);
            }
        }
    }

    @NotNull
    protected abstract String getContentType(@NotNull Context var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeContent(@NotNull HttpURLConnection connection, @NotNull HttpSender.Method method, T content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        connection.setRequestMethod(method.name());
        connection.setDoOutput(true);
        System.setProperty("http.keepAlive", "false");
        connection.connect();
        Closeable closeable = this.senderConfiguration.getCompress() ? (FilterOutputStream)new GZIPOutputStream(connection.getOutputStream(), 8192) : (FilterOutputStream)new BufferedOutputStream(connection.getOutputStream());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FilterOutputStream it = (FilterOutputStream)closeable;
            boolean bl3 = false;
            this.write(it, content);
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    protected abstract void write(@NotNull OutputStream var1, T var2) throws IOException;

    protected final void handleResponse(int responseCode, @NotNull String responseMessage) throws IOException {
        String string;
        ACRALog aCRALog;
        String string2;
        Intrinsics.checkNotNullParameter((Object)responseMessage, (String)"responseMessage");
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Request response : " + responseCode + " : " + responseMessage;
            aCRALog.d(string2, string);
        }
        if (responseCode >= 200 && responseCode < 300) {
            boolean $i$f$info = false;
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Request received by server";
            aCRALog.i(string2, string);
        } else {
            boolean $i$f$warn;
            if (responseCode == 408 || responseCode >= 500) {
                $i$f$warn = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Could not send ACRA Post responseCode=" + responseCode + " message=" + responseMessage;
                aCRALog.w(string2, string);
                throw (Throwable)new IOException("Host returned error code " + responseCode);
            }
            if (responseCode >= 400) {
                $i$f$warn = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = responseCode + ": Client error - request will be discarded";
                aCRALog.w(string2, string);
            } else {
                $i$f$warn = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Could not send ACRA Post - request will be discarded. responseCode=" + responseCode + " message=" + responseMessage;
                aCRALog.w(string2, string);
            }
        }
    }

    public BaseHttpRequest(@NotNull CoreConfiguration config, @NotNull Context context, @NotNull HttpSender.Method method, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.config = config;
        this.context = context;
        this.method = method;
        this.login = login;
        this.password = password;
        this.connectionTimeOut = connectionTimeOut;
        this.socketTimeOut = socketTimeOut;
        this.headers = headers;
        this.senderConfiguration = (HttpSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)this.config, HttpSenderConfiguration.class);
    }
}

