/*
 * Decompiled with CFR 0.152.
 */
package org.acra.http;

import android.content.Context;
import android.net.Uri;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.http.BaseHttpRequest;
import org.acra.log.ACRALog;
import org.acra.sender.HttpSender;
import org.acra.util.UriUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00020\u0001:\u0001\u001aBW\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J*\u0010\u0013\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002H\u0014J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002H\u0014R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/acra/http/MultipartHttpRequest;", "Lorg/acra/http/BaseHttpRequest;", "Lkotlin/Pair;", "", "", "Landroid/net/Uri;", "config", "Lorg/acra/config/CoreConfiguration;", "context", "Landroid/content/Context;", "contentType", "login", "password", "connectionTimeOut", "", "socketTimeOut", "headers", "", "(Lorg/acra/config/CoreConfiguration;Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/util/Map;)V", "getContentType", "t", "write", "", "outputStream", "Ljava/io/OutputStream;", "content", "Companion", "acra-http_release"})
public final class MultipartHttpRequest
extends BaseHttpRequest<Pair<? extends String, ? extends List<? extends Uri>>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String contentType;
    @NotNull
    private static final String BOUNDARY = "%&ACRA_REPORT_DIVIDER&%";
    @NotNull
    private static final String BOUNDARY_FIX = "--";
    @NotNull
    private static final String NEW_LINE = "\r\n";
    @NotNull
    private static final String SECTION_START = "\r\n--%&ACRA_REPORT_DIVIDER&%\r\n";
    @NotNull
    private static final String MESSAGE_END = "\r\n--%&ACRA_REPORT_DIVIDER&%--\r\n";
    @NotNull
    private static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n";
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type: %s\r\n";

    public MultipartHttpRequest(@NotNull CoreConfiguration config, @NotNull Context context, @NotNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        super(config, context, HttpSender.Method.POST, login, password, connectionTimeOut, socketTimeOut, headers);
        this.context = context;
        this.contentType = contentType;
    }

    @Override
    @NotNull
    protected String getContentType(@NotNull Context context, @NotNull Pair<String, ? extends List<? extends Uri>> t) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        return "multipart/form-data; boundary=%&ACRA_REPORT_DIVIDER&%";
    }

    @Override
    protected void write(@NotNull OutputStream outputStream, @NotNull Pair<String, ? extends List<? extends Uri>> content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        Object object = new Object[]{"ACRA_REPORT", ""};
        PrintWriter printWriter = writer.append(SECTION_START).format(CONTENT_DISPOSITION, (Object[])object);
        object = new Object[]{this.contentType};
        printWriter.format(CONTENT_TYPE, (Object[])object).append(NEW_LINE).append((CharSequence)content.getFirst());
        for (Uri uri : (List)content.getSecond()) {
            try {
                String name = UriUtils.INSTANCE.getFileNameFromUri(this.context, uri);
                Object[] objectArray = new Object[]{"ACRA_ATTACHMENT", name};
                PrintWriter printWriter2 = writer.append(SECTION_START).format(CONTENT_DISPOSITION, objectArray);
                objectArray = new Object[]{UriUtils.INSTANCE.getMimeType(this.context, uri)};
                printWriter2.format(CONTENT_TYPE, objectArray).append(NEW_LINE).flush();
                UriUtils.INSTANCE.copyFromUri(this.context, outputStream, uri);
            }
            catch (FileNotFoundException e) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Not sending attachment";
                aCRALog.w(string, string2, (Throwable)e);
            }
        }
        writer.append(MESSAGE_END).flush();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/acra/http/MultipartHttpRequest$Companion;", "", "()V", "BOUNDARY", "", "BOUNDARY_FIX", "CONTENT_DISPOSITION", "CONTENT_TYPE", "MESSAGE_END", "NEW_LINE", "SECTION_START", "acra-http_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

