/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.content.Context;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.log.ACRALog;
import org.acra.security.KeyStoreFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/acra/security/BaseKeyStoreFactory;", "Lorg/acra/security/KeyStoreFactory;", "certificateType", "", "(Ljava/lang/String;)V", "keyStoreType", "getKeyStoreType", "()Ljava/lang/String;", "password", "", "getPassword", "()[C", "streamType", "Lorg/acra/security/BaseKeyStoreFactory$Type;", "getStreamType", "()Lorg/acra/security/BaseKeyStoreFactory$Type;", "create", "Ljava/security/KeyStore;", "context", "Landroid/content/Context;", "getInputStream", "Ljava/io/InputStream;", "Type", "acra-http_release"})
public abstract class BaseKeyStoreFactory
implements KeyStoreFactory {
    @NotNull
    private final String certificateType;

    @JvmOverloads
    public BaseKeyStoreFactory(@NotNull String certificateType) {
        Intrinsics.checkNotNullParameter((Object)certificateType, (String)"certificateType");
        this.certificateType = certificateType;
    }

    public /* synthetic */ BaseKeyStoreFactory(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "X.509";
        }
        this(string);
    }

    @Nullable
    protected abstract InputStream getInputStream(@NotNull Context var1);

    @NotNull
    protected final String getKeyStoreType() {
        String string = KeyStore.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultType()");
        return string;
    }

    @NotNull
    protected final Type getStreamType() {
        return Type.CERTIFICATE;
    }

    @Nullable
    protected final char[] getPassword() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KeyStore create(@NotNull Context context) {
        KeyStore keyStore2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = this.getInputStream(context);
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            Closeable closeable = new BufferedInputStream(it);
            Throwable throwable = null;
            try {
                KeyStore keyStore3;
                block15: {
                    BufferedInputStream it2 = (BufferedInputStream)closeable;
                    boolean bl2 = false;
                    try {
                        KeyStore keyStore4 = KeyStore.getInstance(this.getKeyStoreType());
                        switch (WhenMappings.$EnumSwitchMapping$0[this.getStreamType().ordinal()]) {
                            case 1: {
                                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.certificateType);
                                Certificate certificate = certificateFactory.generateCertificate(it2);
                                keyStore4.load(null, null);
                                keyStore4.setCertificateEntry("ca", certificate);
                                break;
                            }
                            case 2: {
                                keyStore4.load(it2, this.getPassword());
                            }
                        }
                        keyStore3 = keyStore4;
                        break block15;
                    }
                    catch (CertificateException e) {
                        boolean $i$f$error = false;
                        String string = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl3 = false;
                        String string2 = "Could not load certificate";
                        aCRALog.e(string, string2, (Throwable)e);
                    }
                    catch (KeyStoreException e) {
                        boolean $i$f$error = false;
                        String string = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl4 = false;
                        String string3 = "Could not load keystore";
                        aCRALog.e(string, string3, (Throwable)e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        boolean $i$f$error = false;
                        String string = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl5 = false;
                        String string4 = "Could not load keystore";
                        aCRALog.e(string, string4, (Throwable)e);
                    }
                    catch (IOException e) {
                        boolean $i$f$error = false;
                        String string = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl6 = false;
                        String string5 = "Could not load keystore";
                        aCRALog.e(string, string5, (Throwable)e);
                    }
                    keyStore3 = null;
                }
                KeyStore keyStore5 = keyStore3;
                keyStore2 = keyStore5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        keyStore2 = null;
        return keyStore2;
    }

    @JvmOverloads
    public BaseKeyStoreFactory() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/acra/security/BaseKeyStoreFactory$Type;", "", "(Ljava/lang/String;I)V", "CERTIFICATE", "KEYSTORE", "acra-http_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type CERTIFICATE = new Type();
        public static final /* enum */ Type KEYSTORE = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.CERTIFICATE, Type.KEYSTORE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.CERTIFICATE.ordinal()] = 1;
            nArray[Type.KEYSTORE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

