/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.os.Build;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.acra.security.TLS;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/acra/security/ProtocolSocketFactoryWrapper;", "Ljavax/net/ssl/SSLSocketFactory;", "delegate", "protocols", "", "Lorg/acra/security/TLS;", "(Ljavax/net/ssl/SSLSocketFactory;Ljava/util/List;)V", "", "createSocket", "Ljava/net/Socket;", "inetAddress", "Ljava/net/InetAddress;", "i", "", "inetAddress1", "i1", "socket", "s", "b", "", "getDefaultCipherSuites", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "isTLSServerEnabled", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "setProtocols", "acra-http_release"})
public final class ProtocolSocketFactoryWrapper
extends SSLSocketFactory {
    @NotNull
    private final SSLSocketFactory delegate;
    @NotNull
    private final List<String> protocols;

    /*
     * WARNING - void declaration
     */
    public ProtocolSocketFactoryWrapper(@NotNull SSLSocketFactory delegate, @NotNull List<? extends TLS> protocols) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        this.delegate = delegate;
        List list = CollectionsKt.toMutableList((Collection)protocols);
        if (Build.VERSION.SDK_INT < 29) {
            list.remove((Object)TLS.V1_3);
            if (Build.VERSION.SDK_INT < 16) {
                list.remove((Object)TLS.V1_2);
                list.remove((Object)TLS.V1_1);
            }
        }
        Iterable iterable = list;
        ProtocolSocketFactoryWrapper protocolSocketFactoryWrapper = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TLS tLS = (TLS)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        protocolSocketFactoryWrapper.protocols = (List)destination$iv$iv;
    }

    private final Socket setProtocols(Socket socket) {
        if (socket instanceof SSLSocket && this.isTLSServerEnabled((SSLSocket)socket)) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            Collection $this$toTypedArray$iv = this.protocols;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            sSLSocket.setEnabledProtocols(stringArray);
        }
        return socket;
    }

    private final boolean isTLSServerEnabled(SSLSocket sslSocket) {
        String[] stringArray = sslSocket.getSupportedProtocols();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"sslSocket.supportedProtocols");
        for (String protocol : stringArray) {
            if (!this.protocols.contains(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.delegate.getDefaultCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"delegate.defaultCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.delegate.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"delegate.supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull Socket socket, @NotNull String s, int i, boolean b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Socket socket2 = this.delegate.createSocket(socket, s, i, b);
        Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"delegate.createSocket(socket, s, i, b)");
        return this.setProtocols(socket2);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String s, int i) throws IOException, UnknownHostException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Socket socket = this.delegate.createSocket(s, i);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"delegate.createSocket(s, i)");
        return this.setProtocols(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String s, int i, @NotNull InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        Socket socket = this.delegate.createSocket(s, i, inetAddress, i1);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"delegate.createSocket(s, i, inetAddress, i1)");
        return this.setProtocols(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress inetAddress, int i) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        Socket socket = this.delegate.createSocket(inetAddress, i);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"delegate.createSocket(inetAddress, i)");
        return this.setProtocols(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress inetAddress, int i, @NotNull InetAddress inetAddress1, int i1) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        Intrinsics.checkNotNullParameter((Object)inetAddress1, (String)"inetAddress1");
        Socket socket = this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"delegate.createSocket(in\u2026ess, i, inetAddress1, i1)");
        return this.setProtocols(socket);
    }
}

