/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.acra.attachment.AcraContentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lorg/acra/util/UriUtils;", "", "()V", "copyFromUri", "", "context", "Landroid/content/Context;", "outputStream", "Ljava/io/OutputStream;", "uri", "Landroid/net/Uri;", "getFileNameFromUri", "", "getMimeType", "acra-http_release"})
public final class UriUtils {
    @NotNull
    public static final UriUtils INSTANCE = new UriUtils();

    private UriUtils() {
    }

    public final void copyFromUri(@NotNull Context context, @NotNull OutputStream outputStream, @NotNull Uri uri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not open " + uri);
        }
        ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)outputStream, (int)8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getFileNameFromUri(@NotNull Context context, @NotNull Uri uri) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object object = new String[]{"_display_name"};
        Cursor cursor = context.getContentResolver().query(uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor cursor2 = (Cursor)object;
                boolean bl = false;
                if (cursor2.moveToFirst()) {
                    String string = cursor2.getString(cursor2.getColumnIndex("_display_name"));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(cursor.\u2026bleColumns.DISPLAY_NAME))");
                    String string2 = string;
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        throw new FileNotFoundException("Could not resolve filename of " + uri);
    }

    @NotNull
    public final String getMimeType(@NotNull Context context, @NotNull Uri uri) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content") && (string = context.getContentResolver().getType(uri)) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return AcraContentProvider.Companion.guessMimeType(uri);
    }
}

