/*
 * Decompiled with CFR 0.152.
 */
package org.acra.security;

import android.content.Context;
import java.security.KeyStore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.HttpSenderConfiguration;
import org.acra.security.AssetKeyStoreFactory;
import org.acra.security.FileKeyStoreFactory;
import org.acra.security.KeyStoreFactory;
import org.acra.security.KeyStoreHelper;
import org.acra.security.ResourceKeyStoreFactory;
import org.acra.util.InstanceCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/acra/security/KeyStoreHelper;", "", "()V", "ASSET_PREFIX", "", "getKeyStore", "Ljava/security/KeyStore;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "acra-http_release"})
@SourceDebugExtension(value={"SMAP\nKeyStoreHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStoreHelper.kt\norg/acra/security/KeyStoreHelper\n+ 2 ConfigUtils.kt\norg/acra/config/ConfigUtils\n*L\n1#1,61:1\n29#2:62\n*S KotlinDebug\n*F\n+ 1 KeyStoreHelper.kt\norg/acra/security/KeyStoreHelper\n*L\n42#1:62\n*E\n"})
public final class KeyStoreHelper {
    @NotNull
    public static final KeyStoreHelper INSTANCE = new KeyStoreHelper();
    @NotNull
    private static final String ASSET_PREFIX = "asset://";

    private KeyStoreHelper() {
    }

    @Nullable
    public final KeyStore getKeyStore(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CoreConfiguration $this$getPluginConfiguration$iv = config;
        boolean $i$f$getPluginConfiguration = false;
        HttpSenderConfiguration senderConfiguration = (HttpSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, HttpSenderConfiguration.class);
        KeyStore keyStore2 = ((KeyStoreFactory)InstanceCreator.create(senderConfiguration.getKeyStoreFactoryClass(), (Function0)getKeyStore.keyStore.1.INSTANCE)).create(context);
        if (keyStore2 == null) {
            Integer certificateRes = senderConfiguration.getResCertificate();
            String certificatePath = senderConfiguration.getCertificatePath();
            String certificateType = senderConfiguration.getCertificateType();
            if (certificateRes != null) {
                keyStore2 = new ResourceKeyStoreFactory(certificateType, certificateRes).create(context);
            } else if (certificatePath != null) {
                KeyStore keyStore3;
                if (StringsKt.startsWith$default((String)certificatePath, (String)ASSET_PREFIX, (boolean)false, (int)2, null)) {
                    String string = certificatePath.substring(8);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    keyStore3 = new AssetKeyStoreFactory(certificateType, string).create(context);
                } else {
                    keyStore3 = new FileKeyStoreFactory(certificateType, certificatePath).create(context);
                }
                keyStore2 = keyStore3;
            }
        }
        return keyStore2;
    }
}

