/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.net.Uri;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.attachment.AttachmentUriProvider;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.HttpSenderConfiguration;
import org.acra.data.CrashReportData;
import org.acra.data.StringFormat;
import org.acra.http.BinaryHttpRequest;
import org.acra.http.DefaultHttpRequest;
import org.acra.http.MultipartHttpRequest;
import org.acra.log.ACRALog;
import org.acra.sender.HttpSender;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.InstanceCreator;
import org.acra.util.UriUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u00011B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0014Jx\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(H\u0014Jb\u0010)\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010#2\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020\u000eH\u0014J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0015H\u0016J\u0080\u0001\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(H\u0014Jr\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0014J\u001c\u0010/\u001a\u00020\u00182\b\u00100\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/acra/sender/HttpSender;", "Lorg/acra/sender/ReportSender;", "config", "Lorg/acra/config/CoreConfiguration;", "method", "Lorg/acra/sender/HttpSender$Method;", "type", "Lorg/acra/data/StringFormat;", "formUri", "", "(Lorg/acra/config/CoreConfiguration;Lorg/acra/sender/HttpSender$Method;Lorg/acra/data/StringFormat;Ljava/lang/String;)V", "httpConfig", "Lorg/acra/config/HttpSenderConfiguration;", "mFormUri", "Landroid/net/Uri;", "mMethod", "mPassword", "mType", "mUsername", "convertToString", "report", "Lorg/acra/data/CrashReportData;", "format", "postMultipart", "", "configuration", "context", "Landroid/content/Context;", "contentType", "login", "password", "connectionTimeOut", "", "socketTimeOut", "headers", "", "content", "url", "Ljava/net/URL;", "attachments", "", "putAttachment", "attachment", "send", "errorContent", "sendHttpRequests", "sendWithoutAttachments", "setBasicAuth", "username", "Method", "acra-http_release"})
@SourceDebugExtension(value={"SMAP\nHttpSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpSender.kt\norg/acra/sender/HttpSender\n+ 2 ConfigUtils.kt\norg/acra/config/ConfigUtils\n+ 3 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,206:1\n29#2:207\n7#3,2:208\n*S KotlinDebug\n*F\n+ 1 HttpSender.kt\norg/acra/sender/HttpSender\n*L\n70#1:207\n95#1:208,2\n*E\n"})
public class HttpSender
implements ReportSender {
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final HttpSenderConfiguration httpConfig;
    @NotNull
    private final Uri mFormUri;
    @NotNull
    private final Method mMethod;
    @NotNull
    private final StringFormat mType;
    @Nullable
    private String mUsername;
    @Nullable
    private String mPassword;

    @JvmOverloads
    public HttpSender(@NotNull CoreConfiguration config, @Nullable Method method, @Nullable StringFormat type, @Nullable String formUri) {
        StringFormat stringFormat;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CoreConfiguration $this$getPluginConfiguration$iv = this.config = config;
        boolean $i$f$getPluginConfiguration = false;
        this.httpConfig = (HttpSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, HttpSenderConfiguration.class);
        String string = formUri;
        if (string == null) {
            string = this.httpConfig.getUri();
        }
        Uri uri = Uri.parse((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(formUri ?: httpConfig.uri)");
        this.mFormUri = uri;
        Method method2 = method;
        if (method2 == null) {
            method2 = this.mMethod = this.httpConfig.getHttpMethod();
        }
        if ((stringFormat = type) == null) {
            stringFormat = this.config.getReportFormat();
        }
        this.mType = stringFormat;
    }

    public /* synthetic */ HttpSender(CoreConfiguration coreConfiguration, Method method, StringFormat stringFormat, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(coreConfiguration, method, stringFormat, string);
    }

    public void setBasicAuth(@Nullable String username, @Nullable String password) {
        this.mUsername = username;
        this.mPassword = password;
    }

    public void send(@NotNull Context context, @NotNull CrashReportData errorContent) throws ReportSenderException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        try {
            CharSequence charSequence;
            CharSequence charSequence22;
            String string = this.mFormUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mFormUri.toString()");
            String baseUrl = string;
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                String string2 = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean charSequence22 = false;
                String string3 = "Connect to " + baseUrl;
                aCRALog.d(string2, string3);
            }
            String login = this.mUsername != null ? this.mUsername : (!((charSequence22 = (CharSequence)this.httpConfig.getBasicAuthLogin()) == null || charSequence22.length() == 0) ? this.httpConfig.getBasicAuthLogin() : null);
            String password = this.mPassword != null ? this.mPassword : (!((charSequence = (CharSequence)this.httpConfig.getBasicAuthPassword()) == null || charSequence.length() == 0) ? this.httpConfig.getBasicAuthPassword() : null);
            List uris2 = ((AttachmentUriProvider)InstanceCreator.create((Class)this.config.getAttachmentUriProvider(), (Function0)send.uris.1.INSTANCE)).getAttachments(context, this.config);
            String reportAsString = this.convertToString(errorContent, this.mType);
            URL reportUrl = this.mMethod.createURL(baseUrl, errorContent);
            this.sendHttpRequests(this.config, context, this.mMethod, this.mType.getMatchingHttpContentType(), login, password, this.httpConfig.getConnectionTimeout(), this.httpConfig.getSocketTimeout(), this.httpConfig.getHttpHeaders(), reportAsString, reportUrl, uris2);
        }
        catch (Exception e) {
            throw new ReportSenderException("Error while sending " + this.config.getReportFormat() + " report via Http " + this.mMethod.name(), (Throwable)e);
        }
    }

    protected void sendHttpRequests(@NotNull CoreConfiguration configuration, @NotNull Context context, @NotNull Method method, @NotNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NotNull String content, @NotNull URL url, @NotNull List<? extends Uri> attachments) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                if (attachments.isEmpty()) {
                    this.sendWithoutAttachments(configuration, context, method, contentType, login, password, connectionTimeOut, socketTimeOut, headers, content, url);
                    break;
                }
                this.postMultipart(configuration, context, contentType, login, password, connectionTimeOut, socketTimeOut, headers, content, url, attachments);
                break;
            }
            case 2: {
                this.sendWithoutAttachments(configuration, context, method, contentType, login, password, connectionTimeOut, socketTimeOut, headers, content, url);
                for (Uri uri : attachments) {
                    this.putAttachment(configuration, context, login, password, connectionTimeOut, socketTimeOut, headers, url, uri);
                }
                break;
            }
        }
    }

    protected void sendWithoutAttachments(@NotNull CoreConfiguration configuration, @NotNull Context context, @NotNull Method method, @NotNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NotNull String content, @NotNull URL url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        new DefaultHttpRequest(configuration, context, method, contentType, login, password, connectionTimeOut, socketTimeOut, headers).send(url, content);
    }

    protected void postMultipart(@NotNull CoreConfiguration configuration, @NotNull Context context, @NotNull String contentType, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NotNull String content, @NotNull URL url, @NotNull List<? extends Uri> attachments) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        new MultipartHttpRequest(configuration, context, contentType, login, password, connectionTimeOut, socketTimeOut, headers).send(url, TuplesKt.to((Object)content, attachments));
    }

    protected void putAttachment(@NotNull CoreConfiguration configuration, @NotNull Context context, @Nullable String login, @Nullable String password, int connectionTimeOut, int socketTimeOut, @Nullable Map<String, String> headers, @NotNull URL url, @NotNull Uri attachment) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        try {
            URL attachmentUrl = new URL(url.toString() + "-" + UriUtils.INSTANCE.getFileNameFromUri(context, attachment));
            new BinaryHttpRequest(configuration, context, login, password, connectionTimeOut, socketTimeOut, headers).send(attachmentUrl, attachment);
        }
        catch (FileNotFoundException e) {
            ACRA.log.w("Not sending attachment", (Throwable)e);
        }
    }

    @NotNull
    protected String convertToString(@Nullable CrashReportData report, @NotNull StringFormat format) throws Exception {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        CrashReportData crashReportData = report;
        Intrinsics.checkNotNull((Object)crashReportData);
        return format.toFormattedString(crashReportData, this.config.getReportContent(), "&", "\n", true);
    }

    @JvmOverloads
    public HttpSender(@NotNull CoreConfiguration config, @Nullable Method method, @Nullable StringFormat type) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(config, method, type, null, 8, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&j\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/acra/sender/HttpSender$Method;", "", "(Ljava/lang/String;I)V", "createURL", "Ljava/net/URL;", "baseUrl", "", "report", "Lorg/acra/data/CrashReportData;", "POST", "PUT", "acra-http_release"})
    public static final abstract class Method
    extends Enum<Method> {
        public static final /* enum */ Method POST = new POST("POST", 0);
        public static final /* enum */ Method PUT = new PUT("PUT", 1);
        private static final /* synthetic */ Method[] $VALUES;

        private Method() {
        }

        @NotNull
        public abstract URL createURL(@NotNull String var1, @NotNull CrashReportData var2) throws MalformedURLException;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        public /* synthetic */ Method(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = methodArray = new Method[]{Method.POST, Method.PUT};
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/sender/HttpSender$Method$POST;", "Lorg/acra/sender/HttpSender$Method;", "createURL", "Ljava/net/URL;", "baseUrl", "", "report", "Lorg/acra/data/CrashReportData;", "acra-http_release"})
        static final class POST
        extends Method {
            /*
             * WARNING - void declaration
             */
            POST() {
                void var1_1;
            }

            @Override
            @NotNull
            public URL createURL(@NotNull String baseUrl, @NotNull CrashReportData report) throws MalformedURLException {
                Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
                Intrinsics.checkNotNullParameter((Object)report, (String)"report");
                return new URL(baseUrl);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/acra/sender/HttpSender$Method$PUT;", "Lorg/acra/sender/HttpSender$Method;", "createURL", "Ljava/net/URL;", "baseUrl", "", "report", "Lorg/acra/data/CrashReportData;", "acra-http_release"})
        static final class PUT
        extends Method {
            /*
             * WARNING - void declaration
             */
            PUT() {
                void var1_1;
            }

            @Override
            @NotNull
            public URL createURL(@NotNull String baseUrl, @NotNull CrashReportData report) throws MalformedURLException {
                Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
                Intrinsics.checkNotNullParameter((Object)report, (String)"report");
                return new URL(baseUrl + "/" + report.getString(ReportField.REPORT_ID));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

