/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.util.IOUtils;
import org.acra.util.StreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0011\b\u0012\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0003R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/acra/config/LimiterData;", "", "json", "", "(Ljava/lang/String;)V", "()V", "reportMetadata", "", "Lorg/acra/config/LimiterData$ReportMetadata;", "getReportMetadata", "()Ljava/util/List;", "purgeOldData", "", "keepAfter", "Ljava/util/Calendar;", "store", "context", "Landroid/content/Context;", "toJSON", "Companion", "ReportMetadata", "acra-limiter_release"})
public final class LimiterData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ReportMetadata> reportMetadata = new ArrayList();
    @NotNull
    private static final String FILE_LIMITER_DATA = "ACRA-limiter.json";

    public LimiterData() {
    }

    @NotNull
    public final List<ReportMetadata> getReportMetadata() {
        return this.reportMetadata;
    }

    private LimiterData(String json) {
        this();
        if (json != null && ((CharSequence)json).length() > 0) {
            JSONArray array = new JSONArray(json);
            int length = array.length();
            for (int i = 0; i < length; ++i) {
                JSONObject jSONObject = array.optJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"optJSONObject(...)");
                this.reportMetadata.add(new ReportMetadata(jSONObject));
            }
        }
    }

    public final void store(@NotNull Context context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getFileStreamPath(FILE_LIMITER_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFileStreamPath(...)");
        IOUtils.writeStringToFile((File)file, (String)this.toJSON());
    }

    public final void purgeOldData(@NotNull Calendar keepAfter) {
        Intrinsics.checkNotNullParameter((Object)keepAfter, (String)"keepAfter");
        CollectionsKt.removeAll(this.reportMetadata, (Function1)((Function1)new Function1<ReportMetadata, Boolean>(keepAfter){
            final /* synthetic */ Calendar $keepAfter;
            {
                this.$keepAfter = $keepAfter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ReportMetadata it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.$keepAfter.after(it.getTimestamp());
            }
        }));
    }

    @NotNull
    public final String toJSON() {
        String string = new JSONArray((Collection)this.reportMetadata).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final LimiterData load(@NotNull Context context) {
        return Companion.load(context);
    }

    public /* synthetic */ LimiterData(String json, DefaultConstructorMarker $constructor_marker) {
        this(json);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/acra/config/LimiterData$Companion;", "", "()V", "FILE_LIMITER_DATA", "", "jsonArrayToList", "", "array", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Ljava/lang/String;", "load", "Lorg/acra/config/LimiterData;", "context", "Landroid/content/Context;", "acra-limiter_release"})
    @SourceDebugExtension(value={"SMAP\nLimiterData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimiterData.kt\norg/acra/config/LimiterData$Companion\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n19#2,2:137\n19#2,2:139\n37#3,2:141\n*S KotlinDebug\n*F\n+ 1 LimiterData.kt\norg/acra/config/LimiterData$Companion\n*L\n117#1:137,2\n120#1:139,2\n133#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LimiterData load(@NotNull Context context) {
            LimiterData limiterData;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                FileInputStream fileInputStream = context.openFileInput(LimiterData.FILE_LIMITER_DATA);
                Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"openFileInput(...)");
                limiterData = new LimiterData(new StreamReader((InputStream)fileInputStream, 0, 0, null, 14, null).read(), null);
            }
            catch (FileNotFoundException e) {
                limiterData = new LimiterData();
            }
            catch (IOException e) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Failed to load LimiterData";
                aCRALog.w(string, string2, (Throwable)e);
                limiterData = new LimiterData();
            }
            catch (JSONException e) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string3 = "Failed to load LimiterData";
                aCRALog.w(string, string3, (Throwable)e);
                limiterData = new LimiterData();
            }
            return limiterData;
        }

        private final String[] jsonArrayToList(JSONArray array) {
            List list = new ArrayList();
            if (array != null) {
                int length = array.length();
                for (int i = 0; i < length; ++i) {
                    list.add(array.opt(i).toString());
                }
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/acra/config/LimiterData$ReportMetadata;", "Lorg/json/JSONObject;", "crashReportData", "Lorg/acra/data/CrashReportData;", "(Lorg/acra/data/CrashReportData;)V", "copyFrom", "(Lorg/json/JSONObject;)V", "exceptionClass", "", "getExceptionClass", "()Ljava/lang/String;", "stacktrace", "getStacktrace", "timestamp", "Ljava/util/Calendar;", "getTimestamp", "()Ljava/util/Calendar;", "Companion", "acra-limiter_release"})
    @SourceDebugExtension(value={"SMAP\nLimiterData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimiterData.kt\norg/acra/config/LimiterData$ReportMetadata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class ReportMetadata
    extends JSONObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String KEY_STACK_TRACE = "stacktrace";
        @NotNull
        private static final String KEY_EXCEPTION_CLASS = "class";
        @NotNull
        private static final String KEY_TIMESTAMP = "timestamp";

        public ReportMetadata(@NotNull CrashReportData crashReportData) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)crashReportData, (String)"crashReportData");
            String stacktrace = crashReportData.getString(ReportField.STACK_TRACE);
            this.put(KEY_STACK_TRACE, stacktrace);
            String string3 = stacktrace;
            Intrinsics.checkNotNull((Object)string3);
            int index = StringsKt.indexOf$default((CharSequence)string3, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                string2 = stacktrace;
            } else {
                String string4 = stacktrace.substring(0, index);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String firstLine = string2;
            int index2 = StringsKt.indexOf$default((CharSequence)firstLine, (char)':', (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                string = firstLine;
            } else {
                String string5 = firstLine.substring(0, index2);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String className = string;
            try {
                Class.forName(className);
                this.put(KEY_EXCEPTION_CLASS, className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.put(KEY_TIMESTAMP, crashReportData.getString(ReportField.USER_CRASH_DATE));
        }

        public ReportMetadata(@NotNull JSONObject copyFrom) {
            Intrinsics.checkNotNullParameter((Object)copyFrom, (String)"copyFrom");
            super(copyFrom, Companion.jsonArrayToList(copyFrom.names()));
        }

        @NotNull
        public final String getStacktrace() {
            String string = this.optString(KEY_STACK_TRACE);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(...)");
            return string;
        }

        @NotNull
        public final String getExceptionClass() {
            String string = this.optString(KEY_EXCEPTION_CLASS);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(...)");
            return string;
        }

        @Nullable
        public final Calendar getTimestamp() {
            String timestamp;
            String string;
            String it = string = this.optString(KEY_TIMESTAMP);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = timestamp = ((CharSequence)it).length() > 0 ? string : null;
            if (timestamp != null) {
                try {
                    Calendar calendar = Calendar.getInstance();
                    Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ", Locale.ENGLISH).parse(timestamp);
                    Intrinsics.checkNotNull((Object)date);
                    calendar.setTime(date);
                    return calendar;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/acra/config/LimiterData$ReportMetadata$Companion;", "", "()V", "KEY_EXCEPTION_CLASS", "", "KEY_STACK_TRACE", "KEY_TIMESTAMP", "acra-limiter_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

