/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.builder.ReportBuilder;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.LimiterConfiguration;
import org.acra.config.LimiterData;
import org.acra.config.ReportingAdministrator;
import org.acra.data.CrashReportData;
import org.acra.file.ReportLocator;
import org.acra.log.ACRALog;
import org.acra.plugins.HasConfigPlugin;
import org.acra.util.ToastSender;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0012J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/acra/config/LimitingReportAdministrator;", "Lorg/acra/plugins/HasConfigPlugin;", "Lorg/acra/config/ReportingAdministrator;", "()V", "loadLimiterData", "Lorg/acra/config/LimiterData;", "context", "Landroid/content/Context;", "limiterConfiguration", "Lorg/acra/config/LimiterConfiguration;", "notifyReportDropped", "", "config", "Lorg/acra/config/CoreConfiguration;", "shouldSendReport", "", "crashReportData", "Lorg/acra/data/CrashReportData;", "shouldStartCollecting", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "acra-limiter_release"})
@AutoService(value={ReportingAdministrator.class})
@SourceDebugExtension(value={"SMAP\nLimitingReportAdministrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitingReportAdministrator.kt\norg/acra/config/LimitingReportAdministrator\n+ 2 ConfigUtils.kt\norg/acra/config/ConfigUtils\n+ 3 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,137:1\n29#2:138\n29#2:145\n29#2:154\n7#3,2:139\n7#3,2:141\n19#3,2:143\n7#3,2:146\n7#3,2:148\n19#3,2:150\n19#3,2:152\n7#3,2:155\n*S KotlinDebug\n*F\n+ 1 LimitingReportAdministrator.kt\norg/acra/config/LimitingReportAdministrator\n*L\n47#1:138\n66#1:145\n98#1:154\n50#1:139,2\n55#1:141,2\n59#1:143,2\n80#1:146,2\n84#1:148,2\n90#1:150,2\n92#1:152,2\n132#1:155,2\n*E\n"})
public class LimitingReportAdministrator
extends HasConfigPlugin
implements ReportingAdministrator {
    public LimitingReportAdministrator() {
        super(LimiterConfiguration.class);
    }

    public boolean shouldStartCollecting(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        try {
            CoreConfiguration $this$getPluginConfiguration$iv = config;
            boolean $i$f$getPluginConfiguration = false;
            LimiterConfiguration limiterConfiguration = (LimiterConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, LimiterConfiguration.class);
            ReportLocator reportLocator = new ReportLocator(context);
            if (reportLocator.getApprovedReports().length + reportLocator.getUnapprovedReports().length >= limiterConfiguration.getFailedReportLimit()) {
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "Reached failedReportLimit, not collecting";
                    aCRALog.d(string, string2);
                }
                return false;
            }
            List<LimiterData.ReportMetadata> reportMetadata = this.loadLimiterData(context, limiterConfiguration).getReportMetadata();
            if (reportMetadata.size() >= limiterConfiguration.getOverallLimit()) {
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string3 = "Reached overallLimit, not collecting";
                    aCRALog.d(string, string3);
                }
                return false;
            }
        }
        catch (IOException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string4 = "Failed to load LimiterData";
            aCRALog.w(string, string4, (Throwable)e);
        }
        return true;
    }

    public boolean shouldSendReport(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull CrashReportData crashReportData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)crashReportData, (String)"crashReportData");
        try {
            CoreConfiguration $this$getPluginConfiguration$iv = config;
            boolean $i$f$getPluginConfiguration = false;
            LimiterConfiguration limiterConfiguration = (LimiterConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, LimiterConfiguration.class);
            LimiterData limiterData = this.loadLimiterData(context, limiterConfiguration);
            int sameTrace = 0;
            int sameClass = 0;
            LimiterData.ReportMetadata m = new LimiterData.ReportMetadata(crashReportData);
            for (LimiterData.ReportMetadata metadata : limiterData.getReportMetadata()) {
                if (Intrinsics.areEqual((Object)m.getStacktrace(), (Object)metadata.getStacktrace())) {
                    ++sameTrace;
                }
                if (!Intrinsics.areEqual((Object)m.getExceptionClass(), (Object)metadata.getExceptionClass())) continue;
                ++sameClass;
            }
            if (sameTrace >= limiterConfiguration.getStacktraceLimit()) {
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "Reached stacktraceLimit, not sending";
                    aCRALog.d(string, string2);
                }
                return false;
            }
            if (sameClass >= limiterConfiguration.getExceptionClassLimit()) {
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string3 = "Reached exceptionClassLimit, not sending";
                    aCRALog.d(string, string3);
                }
                return false;
            }
            limiterData.getReportMetadata().add(m);
            limiterData.store(context);
        }
        catch (IOException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string4 = "Failed to load LimiterData";
            aCRALog.w(string, string4, (Throwable)e);
        }
        catch (JSONException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string5 = "Failed to load LimiterData";
            aCRALog.w(string, string5, (Throwable)e);
        }
        return true;
    }

    public void notifyReportDropped(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CoreConfiguration $this$getPluginConfiguration$iv = config;
        boolean $i$f$getPluginConfiguration2 = false;
        LimiterConfiguration limiterConfiguration = (LimiterConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, LimiterConfiguration.class);
        String string = limiterConfiguration.getIgnoredCrashToast();
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            Future<?> future = Executors.newSingleThreadExecutor().submit(() -> LimitingReportAdministrator.notifyReportDropped$lambda$8(context, limiterConfiguration));
            while (!future.isDone()) {
                try {
                    future.get();
                }
                catch (InterruptedException $i$f$getPluginConfiguration2) {
                }
                catch (ExecutionException e) {
                    break;
                }
            }
        }
    }

    private LimiterData loadLimiterData(Context context, LimiterConfiguration limiterConfiguration) throws IOException {
        LimiterData limiterData = LimiterData.Companion.load(context);
        Calendar keepAfter = Calendar.getInstance();
        keepAfter.add(12, (int)(-limiterConfiguration.getPeriodUnit().toMinutes(limiterConfiguration.getPeriod())));
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "purging reports older than " + keepAfter.getTime();
            aCRALog.d(string, string2);
        }
        Intrinsics.checkNotNull((Object)keepAfter);
        limiterData.purgeOldData(keepAfter);
        limiterData.store(context);
        return limiterData;
    }

    private static final void notifyReportDropped$lambda$8$lambda$7(Looper $looper) {
        if (Build.VERSION.SDK_INT >= 18) {
            $looper.quitSafely();
        } else {
            $looper.quit();
        }
    }

    private static final void notifyReportDropped$lambda$8(Context $context, LimiterConfiguration $limiterConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$limiterConfiguration, (String)"$limiterConfiguration");
        Looper.prepare();
        ToastSender.sendToast((Context)$context, (String)$limiterConfiguration.getIgnoredCrashToast(), (int)1);
        Looper looper = Looper.myLooper();
        if (looper != null) {
            new Handler(looper).postDelayed(() -> LimitingReportAdministrator.notifyReportDropped$lambda$8$lambda$7(looper), 4000L);
            Looper.loop();
        }
    }
}

