/*
 * Decompiled with CFR 0.152.
 */
package org.acra.startup;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.LimiterConfiguration;
import org.acra.config.LimiterData;
import org.acra.log.ACRALog;
import org.acra.plugins.HasConfigPlugin;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.startup.Report;
import org.acra.startup.StartupProcessor;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.PackageManagerWrapperKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J&\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/acra/startup/LimiterStartupProcessor;", "Lorg/acra/plugins/HasConfigPlugin;", "Lorg/acra/startup/StartupProcessor;", "()V", "getAppVersion", "", "context", "Landroid/content/Context;", "processReports", "", "config", "Lorg/acra/config/CoreConfiguration;", "reports", "", "Lorg/acra/startup/Report;", "acra-limiter_release"})
@AutoService(value={StartupProcessor.class})
@SourceDebugExtension(value={"SMAP\nLimiterStartupProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimiterStartupProcessor.kt\norg/acra/startup/LimiterStartupProcessor\n+ 2 ConfigUtils.kt\norg/acra/config/ConfigUtils\n+ 3 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,74:1\n29#2:75\n19#3,2:76\n*S KotlinDebug\n*F\n+ 1 LimiterStartupProcessor.kt\norg/acra/startup/LimiterStartupProcessor\n*L\n39#1:75\n63#1:76,2\n*E\n"})
public class LimiterStartupProcessor
extends HasConfigPlugin
implements StartupProcessor {
    public LimiterStartupProcessor() {
        super(LimiterConfiguration.class);
    }

    public void processReports(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull List<Report> reports) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(reports, (String)"reports");
        CoreConfiguration $this$getPluginConfiguration$iv = config;
        boolean $i$f$getPluginConfiguration = false;
        LimiterConfiguration limiterConfiguration = (LimiterConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, LimiterConfiguration.class);
        if (limiterConfiguration.getDeleteReportsOnAppUpdate() || limiterConfiguration.getResetLimitsOnAppUpdate()) {
            long l;
            SharedPreferences prefs = new SharedPreferencesFactory(context, config).create();
            try {
                try {
                    l = prefs.getLong("acra.lastVersionNr", 0L);
                }
                catch (ClassCastException e) {
                    l = prefs.getInt("acra.lastVersionNr", 0);
                }
            }
            catch (Exception e) {
                l = 0L;
            }
            long lastVersionNr = l;
            long appVersion = this.getAppVersion(context);
            if (appVersion > lastVersionNr) {
                if (limiterConfiguration.getDeleteReportsOnAppUpdate()) {
                    prefs.edit().putLong("acra.lastVersionNr", appVersion).apply();
                    for (Report report : reports) {
                        report.setDelete(true);
                    }
                }
                if (limiterConfiguration.getResetLimitsOnAppUpdate()) {
                    try {
                        new LimiterData().store(context);
                    }
                    catch (IOException e) {
                        boolean $i$f$warn = false;
                        String string = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl = false;
                        String string2 = "Failed to reset LimiterData";
                        aCRALog.w(string, string2, (Throwable)e);
                    }
                }
            }
        }
    }

    private long getAppVersion(Context context) {
        PackageInfo packageInfo = new PackageManagerWrapper(context).getPackageInfo();
        return packageInfo != null ? PackageManagerWrapperKt.getVersionCodeLong((PackageInfo)packageInfo) : 0L;
    }
}

